/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tesla.lib;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TeslaUtils {
    public static final int TESLA = 1;
    public static final int KILOTESLA = 1000;
    public static final int MEGATESLA = 1000000;
    public static final int GIGATESLA = 1000000000;
    public static final long TERATESLA = 1000000000000L;
    public static final long PENTATESLA = 1000000000000000L;
    public static final long EXATESLA = 1000000000000000000L;

    public static String getDisplayableTeslaCount(long tesla) {
        if (tesla < 1000L) {
            return tesla + " T";
        }
        int exp = (int)(Math.log(tesla) / Math.log(1000.0));
        char unitType = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sT", (double)tesla / Math.pow(1000.0, exp), Character.valueOf(unitType));
    }

    public static String getUnitType(long tesla) {
        if (tesla < 1000L) {
            return tesla + "t";
        }
        int exp = (int)(Math.log(tesla) / Math.log(1000.0));
        return "kmgtpe".charAt(exp - 1) + "t";
    }

    public static String getLocalizedUnitType(long tesla) {
        return I18n.func_135052_a((String)("unit.tesla." + TeslaUtils.getUnitType(tesla)), (Object[])new Object[0]);
    }

    public static boolean hasTeslaSupport(ICapabilityProvider provider, EnumFacing side) {
        return TeslaUtils.isTeslaHolder(provider, side) || TeslaUtils.isTeslaConsumer(provider, side) || TeslaUtils.isTeslaProducer(provider, side);
    }

    public static boolean isTeslaHolder(ICapabilityProvider provider, EnumFacing side) {
        return provider.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side);
    }

    public static boolean isTeslaConsumer(ICapabilityProvider provider, EnumFacing side) {
        return provider.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side);
    }

    public static boolean isTeslaProducer(ICapabilityProvider provider, EnumFacing side) {
        return provider.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side);
    }

    public static ITeslaHolder getTeslaHolder(ICapabilityProvider provider, EnumFacing side) {
        return (ITeslaHolder)provider.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side);
    }

    public static ITeslaConsumer getTeslaConsumer(ICapabilityProvider provider, EnumFacing side) {
        return (ITeslaConsumer)provider.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side);
    }

    public static ITeslaProducer getTeslaProducer(ICapabilityProvider provider, EnumFacing side) {
        return (ITeslaProducer)provider.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side);
    }

    public static long getCapacity(ICapabilityProvider provider, EnumFacing side) {
        return TeslaUtils.isTeslaHolder(provider, side) ? TeslaUtils.getTeslaHolder(provider, side).getCapacity() : 0L;
    }

    public static long getStoredPower(ICapabilityProvider provider, EnumFacing side) {
        return TeslaUtils.isTeslaHolder(provider, side) ? TeslaUtils.getTeslaHolder(provider, side).getStoredPower() : 0L;
    }

    public static long givePower(ICapabilityProvider provider, EnumFacing side, long power, boolean simulated) {
        return TeslaUtils.isTeslaConsumer(provider, side) ? TeslaUtils.getTeslaConsumer(provider, side).givePower(power, simulated) : 0L;
    }

    public static long takePower(ICapabilityProvider provider, EnumFacing side, long power, boolean simulated) {
        return TeslaUtils.isTeslaProducer(provider, side) ? TeslaUtils.getTeslaProducer(provider, side).takePower(power, simulated) : 0L;
    }

    public static <T> List<T> getConnectedCapabilities(Capability<T> capability, World world, BlockPos pos) {
        ArrayList<Object> capabilities = new ArrayList<Object>();
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(side));
            if (tile == null || tile.func_145837_r() || !tile.hasCapability(capability, side.func_176734_d())) continue;
            capabilities.add(tile.getCapability(capability, side.func_176734_d()));
        }
        return capabilities;
    }

    public static long distributePowerToAllFaces(World world, BlockPos pos, long amount, boolean simulated) {
        long consumedPower = 0L;
        for (ITeslaConsumer consumer : TeslaUtils.getConnectedCapabilities(TeslaCapabilities.CAPABILITY_CONSUMER, world, pos)) {
            consumedPower += consumer.givePower(amount, simulated);
        }
        return consumedPower;
    }

    public static long consumePowerFromAllFaces(World world, BlockPos pos, long amount, boolean simulated) {
        long recievedPower = 0L;
        for (ITeslaProducer producer : TeslaUtils.getConnectedCapabilities(TeslaCapabilities.CAPABILITY_PRODUCER, world, pos)) {
            recievedPower += producer.takePower(amount, simulated);
        }
        return recievedPower;
    }
}

