/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.unidict.Config;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.helper.RecipeHelper;
import wanion.unidict.recipe.IRecipeResearcher;
import wanion.unidict.resource.ResourceHandler;

public class ForgeRecipeResearcher
implements IRecipeResearcher<ShapedOreRecipe, ShapelessOreRecipe> {
    @Override
    public int getShapedRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        return MetaItem.getCumulative(((ShapedOreRecipe)recipe).getInput(), resourceHandler);
    }

    @Override
    public int getShapelessRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        return MetaItem.getCumulative(((ShapelessOreRecipe)recipe).getInput().toArray(), resourceHandler);
    }

    @Override
    @Nonnull
    public List<Class<? extends ShapedOreRecipe>> getShapedRecipeClasses() {
        Class<?> shapedCustomRecipe = null;
        try {
            if (Config.forestry) {
                shapedCustomRecipe = Class.forName("forestry.core.recipes.ShapedRecipeCustom");
            }
        }
        catch (ClassNotFoundException e) {
            UniDict.getLogger().error((Object)e);
        }
        return shapedCustomRecipe == null ? Collections.singletonList(ShapedOreRecipe.class) : Arrays.asList(ShapedOreRecipe.class, shapedCustomRecipe);
    }

    @Override
    @Nonnull
    public List<Class<? extends ShapelessOreRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(ShapelessOreRecipe.class);
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        Object[] recipeInputs = ((ShapedOreRecipe)recipe).getInput();
        Object[] newRecipeInputs = new Object[9];
        for (int i = 0; i < 9; ++i) {
            String bufferOreName;
            Object input;
            Object object = input = i < recipeInputs.length ? recipeInputs[i] : null;
            String string = input != null ? (input instanceof List ? uniOreDictionary.getName(input) : (input instanceof ItemStack ? resourceHandler.getContainerName((ItemStack)input) : null)) : (bufferOreName = null);
            newRecipeInputs[i] = input != null ? (bufferOreName != null ? bufferOreName : input) : null;
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newRecipeInputs));
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        Object[] recipeInputs = ((ShapelessOreRecipe)recipe).getInput().toArray();
        Object[] newRecipeInputs = new Object[recipeInputs.length];
        for (int i = 0; i < recipeInputs.length; ++i) {
            String bufferOreName;
            Object input;
            Object object = input = i < recipeInputs.length ? recipeInputs[i] : null;
            String string = input != null ? (input instanceof List ? uniOreDictionary.getName(input) : (input instanceof ItemStack ? resourceHandler.getContainerName((ItemStack)input) : null)) : (bufferOreName = null);
            newRecipeInputs[i] = input != null ? (bufferOreName != null ? bufferOreName : input) : null;
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newRecipeInputs));
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList inputs = new ArrayList();
        ((ShapelessOreRecipe)recipe).getInput().forEach(object -> {
            if (object != null) {
                String bufferOreName;
                String string = object instanceof List ? uniOreDictionary.getName(object) : (bufferOreName = object instanceof ItemStack ? resourceHandler.getContainerName((ItemStack)object) : null);
                if (bufferOreName != null) {
                    inputs.add(bufferOreName);
                } else if (object instanceof ItemStack) {
                    inputs.add(object);
                }
            }
        });
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        for (Object object : ((ShapedOreRecipe)recipe).getInput()) {
            String bufferOreName;
            if (object == null) continue;
            String string = object instanceof List ? uniOreDictionary.getName(object) : (bufferOreName = object instanceof ItemStack ? resourceHandler.getContainerName((ItemStack)object) : null);
            if (bufferOreName != null) {
                inputs.add(bufferOreName);
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            inputs.add(object);
        }
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }
}

