/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import wanion.unidict.Config;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class MekanismIntegration
extends AbstractIntegrationThread {
    MekanismIntegration() {
        super("Mekanism");
    }

    @Override
    public String call() {
        try {
            this.fixMekanismRecipes(RecipeHandler.Recipe.CRUSHER.get());
            this.fixMekanismRecipes(RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get());
            this.fixInfusionMekanismRecipes(RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "All the mekanisms were checked.";
    }

    private void fixMekanismRecipes(@Nonnull Map<ItemStackInput, MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe>> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, MachineRecipe> correctRecipes = new HashMap<MachineInput, MachineRecipe>(initialSize, 1.0f);
        TIntHashSet uniques = new TIntHashSet(initialSize, 1.0f);
        Iterator<MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe>> mekanismRecipeIterator = recipes.values().iterator();
        while (mekanismRecipeIterator.hasNext()) {
            int recipeID;
            MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe> mekanismRecipe = mekanismRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
            if (correctOutput == ((ItemStackOutput)mekanismRecipe.recipeOutput).output) continue;
            MachineRecipe newRecipe = mekanismRecipe.copy();
            ((ItemStackOutput)newRecipe.recipeOutput).output = correctOutput;
            if (Config.keepOneEntry) {
                ((ItemStackInput)newRecipe.recipeInput).ingredient = this.resourceHandler.getMainItemStack(((ItemStackInput)newRecipe.recipeInput).ingredient);
            }
            if (!uniques.contains(recipeID = MetaItem.getCumulative(((ItemStackOutput)newRecipe.recipeOutput).output, ((ItemStackInput)newRecipe.recipeInput).ingredient))) {
                correctRecipes.put(newRecipe.recipeInput, newRecipe);
                uniques.add(recipeID);
            }
            mekanismRecipeIterator.remove();
        }
        recipes.putAll(correctRecipes);
    }

    private void fixInfusionMekanismRecipes(@Nonnull Map<InfusionInput, MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, MachineRecipe> correctRecipes = new HashMap<MachineInput, MachineRecipe>(initialSize, 1.0f);
        TIntHashSet uniques = new TIntHashSet(initialSize, 1.0f);
        Iterator<MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>> infusionRecipeIterator = recipes.values().iterator();
        while (infusionRecipeIterator.hasNext()) {
            int recipeID;
            MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe> infusionRecipe = infusionRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(((ItemStackOutput)infusionRecipe.recipeOutput).output);
            if (correctOutput == ((ItemStackOutput)infusionRecipe.recipeOutput).output) continue;
            MachineRecipe newRecipe = infusionRecipe.copy();
            ((ItemStackOutput)newRecipe.recipeOutput).output = correctOutput;
            if (Config.keepOneEntry) {
                ((InfusionInput)newRecipe.recipeInput).inputStack = this.resourceHandler.getMainItemStack(((InfusionInput)newRecipe.recipeInput).inputStack);
            }
            if (!uniques.contains(recipeID = MetaItem.getCumulative(((ItemStackOutput)newRecipe.recipeOutput).output, ((InfusionInput)newRecipe.recipeInput).inputStack))) {
                correctRecipes.put(newRecipe.recipeInput, newRecipe);
                uniques.add(recipeID);
            }
            infusionRecipeIterator.remove();
        }
        recipes.putAll(correctRecipes);
    }
}

