/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.CarpenterRecipe;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class ForestryIntegration
extends AbstractIntegrationThread {
    private Set<ICarpenterRecipe> carpenterRecipes = (Set)Util.getField(CarpenterRecipeManager.class, "recipes", null, Set.class);
    private FMLControlledNamespacedRegistry<Item> itemRegistry = MetaItem.itemRegistry;

    ForestryIntegration() {
        super("Forestry");
    }

    @Override
    public String call() {
        try {
            this.removeBadCarpenterOutputs(this.carpenterRecipes);
            if (this.resourceHandler.containerExists("ingotBronze")) {
                this.bronzeThings();
            }
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "All these bees... they can hurt, you know?";
    }

    private void removeBadCarpenterOutputs(@Nonnull Set<ICarpenterRecipe> carpenterRecipes) {
        Iterator<ICarpenterRecipe> carpenterRecipeIterator = carpenterRecipes.iterator();
        while (carpenterRecipeIterator.hasNext()) {
            IDescriptiveRecipe carpenterRecipe = carpenterRecipeIterator.next().getCraftingGridRecipe();
            if (carpenterRecipe == null || !this.resourceHandler.exists(MetaItem.get(carpenterRecipe.func_77571_b()))) continue;
            carpenterRecipeIterator.remove();
        }
    }

    private void bronzeThings() {
        UniResourceContainer ingotBronze = this.resourceHandler.getContainer("ingotBronze");
        this.carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, null, null, new ShapedRecipeCustom(ingotBronze.getMainEntry(2), new Object[]{"X  ", "   ", "   ", Character.valueOf('X'), new ItemStack((Item)this.itemRegistry.getObject(new ResourceLocation("forestry:brokenBronzePickaxe")))})));
        this.carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, null, null, new ShapedRecipeCustom(ingotBronze.getMainEntry(1), new Object[]{"X  ", "   ", "   ", Character.valueOf('X'), new ItemStack((Item)this.itemRegistry.getObject(new ResourceLocation("forestry:brokenBronzeShovel")))})));
    }
}

