/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import crazypants.enderio.machine.alloy.AlloyRecipeManager;
import crazypants.enderio.machine.recipe.BasicManyToOneRecipe;
import crazypants.enderio.machine.recipe.IManyToOneRecipe;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeOutput;
import crazypants.enderio.machine.sagmill.SagMillRecipeManager;
import crazypants.enderio.material.OreDictionaryPreferences;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import wanion.unidict.UniDict;
import wanion.unidict.common.FixedSizeList;
import wanion.unidict.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class EnderIOIntegration
extends AbstractIntegrationThread {
    EnderIOIntegration() {
        super("Ender IO");
    }

    @Override
    public String call() {
        try {
            this.fixOreDictPreferences();
            this.fixAlloySmelterRecipes();
            this.fixSagMillRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Some inanimate objects appear to have used ender pearls. They all disappeared, how this is possible?";
    }

    private void fixOreDictPreferences() {
        Map preferences = (Map)Util.getField(OreDictionaryPreferences.class, "preferences", OreDictionaryPreferences.instance, Map.class);
        if (preferences != null) {
            preferences.clear();
        }
    }

    private void fixAlloySmelterRecipes() {
        List alloySmelterRecipes = AlloyRecipeManager.getInstance().getRecipes();
        FixedSizeList<BasicManyToOneRecipe> newAlloySmelterRecipes = new FixedSizeList<BasicManyToOneRecipe>(alloySmelterRecipes.size());
        Iterator alloySmelterRecipesIterator = alloySmelterRecipes.iterator();
        while (alloySmelterRecipesIterator.hasNext()) {
            IManyToOneRecipe alloySmelterRecipe = (IManyToOneRecipe)alloySmelterRecipesIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(alloySmelterRecipe.getOutput());
            if (correctOutput == alloySmelterRecipe.getOutput()) continue;
            RecipeOutput recipeOutput = alloySmelterRecipe.getOutputs()[0];
            newAlloySmelterRecipes.add(new BasicManyToOneRecipe(new Recipe(new RecipeOutput(correctOutput, recipeOutput.getChance(), recipeOutput.getExperiance()), alloySmelterRecipe.getEnergyRequired(), alloySmelterRecipe.getBonusType(), alloySmelterRecipe.getInputs())));
            alloySmelterRecipesIterator.remove();
        }
        alloySmelterRecipes.addAll(newAlloySmelterRecipes);
    }

    private void fixSagMillRecipes() {
        List sagMillRecipes = SagMillRecipeManager.getInstance().getRecipes();
        FixedSizeList newSagMillRecipes = new FixedSizeList(sagMillRecipes.size());
        newSagMillRecipes.addAll(sagMillRecipes.stream().map(this::sagMillRecipe).collect(Collectors.toList()));
        sagMillRecipes.clear();
        sagMillRecipes.addAll(newSagMillRecipes);
    }

    private Recipe sagMillRecipe(Recipe sagMillRecipe) {
        int outputSize = sagMillRecipe.getOutputs().length;
        RecipeOutput[] output = new RecipeOutput[outputSize];
        for (int i = 0; i < outputSize; ++i) {
            RecipeOutput oldOutput = sagMillRecipe.getOutputs()[i];
            output[i] = new RecipeOutput(this.resourceHandler.getMainItemStack(oldOutput.getOutput()), oldOutput.getChance(), oldOutput.getExperiance());
        }
        return new Recipe(sagMillRecipe.getInputs(), output, sagMillRecipe.getEnergyRequired(), sagMillRecipe.getBonusType());
    }
}

