/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.helper.RecipeHelper;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.recipe.ForgeRecipeResearcher;
import wanion.unidict.recipe.IC2RecipeResearcher;
import wanion.unidict.recipe.IRecipeResearcher;
import wanion.unidict.recipe.VanillaRecipeResearcher;
import wanion.unidict.resource.UniResourceContainer;

final class CraftingIntegration
extends AbstractIntegrationThread {
    private final UniOreDictionary uniOreDictionary = UniDict.getDependencies().get(UniOreDictionary.class);
    private final List<IRecipe> recipes = RecipeHelper.recipes;
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapedResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapelessResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();
    private final Map<UniResourceContainer, TIntObjectMap<IRecipe>> smartRecipeMap = new IdentityHashMap<UniResourceContainer, TIntObjectMap<IRecipe>>();

    CraftingIntegration() {
        super("Crafting");
        ArrayList<IRecipeResearcher<ShapedRecipes, ShapelessRecipes>> researcherList = new ArrayList<IRecipeResearcher<ShapedRecipes, ShapelessRecipes>>();
        researcherList.add(new VanillaRecipeResearcher());
        researcherList.add(new ForgeRecipeResearcher());
        if (Config.ic2) {
            researcherList.add(new IC2RecipeResearcher());
        }
        researcherList.forEach(researcher -> {
            researcher.getShapedRecipeClasses().forEach(shapedRecipeClass -> this.shapedResearcherMap.put((Class<? extends IRecipe>)shapedRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
            researcher.getShapelessRecipeClasses().forEach(shapelessRecipeClass -> this.shapelessResearcherMap.put((Class<? extends IRecipe>)shapelessRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
        });
    }

    @Override
    public String call() {
        try {
            this.doTheResearch();
            this.reCreateTheRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "Why so many recipes? I had to deal with a lot of recipes.";
    }

    private void doTheResearch() {
        Iterator<IRecipe> recipeIterator = this.recipes.iterator();
        while (recipeIterator.hasNext()) {
            TIntObjectHashMap evenSmarterRecipeMap;
            int recipeKey;
            UniResourceContainer bufferContainer;
            boolean isShapeless = false;
            IRecipe bufferRecipe = recipeIterator.next();
            if (bufferRecipe == null || (bufferContainer = this.resourceHandler.getContainer(bufferRecipe.func_77571_b())) == null || !this.shapedResearcherMap.containsKey(bufferRecipe.getClass()) && !(isShapeless = this.shapelessResearcherMap.containsKey(bufferRecipe.getClass())) || (recipeKey = !isShapeless ? this.shapedResearcherMap.get(bufferRecipe.getClass()).getShapedRecipeKey(bufferRecipe, this.resourceHandler) : this.shapelessResearcherMap.get(bufferRecipe.getClass()).getShapelessRecipeKey(bufferRecipe, this.resourceHandler)) == 0) continue;
            if (!this.smartRecipeMap.containsKey(bufferContainer)) {
                evenSmarterRecipeMap = new TIntObjectHashMap();
                this.smartRecipeMap.put(bufferContainer, (TIntObjectMap<IRecipe>)evenSmarterRecipeMap);
            } else {
                evenSmarterRecipeMap = this.smartRecipeMap.get(bufferContainer);
            }
            if (!evenSmarterRecipeMap.containsKey(recipeKey)) {
                evenSmarterRecipeMap.put(recipeKey, (Object)bufferRecipe);
            }
            recipeIterator.remove();
        }
    }

    private void reCreateTheRecipes() {
        this.smartRecipeMap.forEach((container, evenSmartRecipeMap) -> evenSmartRecipeMap.forEachValue(recipe -> {
            IRecipeResearcher<? extends IRecipe, ? extends IRecipe> recipeResearcher;
            boolean isShapeless = this.shapelessResearcherMap.containsKey(recipe.getClass());
            IRecipeResearcher<? extends IRecipe, ? extends IRecipe> iRecipeResearcher = recipeResearcher = !isShapeless ? this.shapedResearcherMap.get(recipe.getClass()) : this.shapelessResearcherMap.get(recipe.getClass());
            if (recipe.func_77570_a() == 9) {
                this.recipes.add((IRecipe)(isShapeless ? recipeResearcher.getNewShapedFromShapelessRecipe((IRecipe)recipe, this.resourceHandler, this.uniOreDictionary) : recipeResearcher.getNewShapedRecipe((IRecipe)recipe, this.resourceHandler, this.uniOreDictionary)));
            } else if (recipe.func_77570_a() == 1) {
                this.recipes.add((IRecipe)(isShapeless ? recipeResearcher.getNewShapelessRecipe((IRecipe)recipe, this.resourceHandler, this.uniOreDictionary) : recipeResearcher.getNewShapelessFromShapedRecipe((IRecipe)recipe, this.resourceHandler, this.uniOreDictionary)));
            } else {
                this.recipes.add((IRecipe)(isShapeless ? recipeResearcher.getNewShapelessRecipe((IRecipe)recipe, this.resourceHandler, this.uniOreDictionary) : recipeResearcher.getNewShapedRecipe((IRecipe)recipe, this.resourceHandler, this.uniOreDictionary)));
            }
            return true;
        }));
    }
}

