/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import wanion.unidict.Config;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.common.Dependencies;
import wanion.unidict.common.SpecificKindItemStackComparator;
import wanion.unidict.integration.IntegrationModule;
import wanion.unidict.module.AbstractModule;
import wanion.unidict.module.ModuleHandler;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniResourceHandler;

@Mod(modid="UniDict", name="UniDict", version="1.10.2-1.6", acceptedMinecraftVersions="[1.10.2]", dependencies="after:*")
public final class UniDict {
    @Mod.Instance(value="UniDict")
    public static UniDict instance;
    private static Dependencies<IDependence> dependencies;
    private static Logger logger;
    private UniResourceHandler uniResourceHandler = UniResourceHandler.create();
    private ModuleHandler moduleHandler;

    public static Dependencies<IDependence> getDependencies() {
        return dependencies;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static ResourceHandler getResourceHandler() {
        return dependencies.get(ResourceHandler.class);
    }

    public static UniDictAPI getAPI() {
        return dependencies.get(UniDictAPI.class);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Config.init();
        this.moduleHandler = this.searchForModules(this.populateModules(new ModuleHandler()), event.getAsmData());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.uniResourceHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.uniResourceHandler.postInit();
        this.moduleHandler.startModules((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.moduleHandler.startModules((FMLStateEvent)event);
        SpecificKindItemStackComparator.nullify();
        this.uniResourceHandler = null;
        this.moduleHandler = null;
        dependencies = null;
    }

    private ModuleHandler populateModules(ModuleHandler moduleHandler) {
        if (Config.integrationModule) {
            moduleHandler.addModule(new IntegrationModule());
        }
        return moduleHandler;
    }

    private ModuleHandler searchForModules(ModuleHandler moduleHandler, ASMDataTable asmDataTable) {
        Set modules = asmDataTable.getAll("wanion.unidict.UniDict$Module");
        modules.forEach(asmData -> {
            try {
                Class<?> mayBeAModule = Class.forName(asmData.getClassName());
                if (mayBeAModule.getSuperclass().isAssignableFrom(AbstractModule.class)) {
                    moduleHandler.addModule((AbstractModule)mayBeAModule.newInstance());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Cannot load ", new Object[]{asmData.getClassName(), e});
            }
        });
        return moduleHandler;
    }

    @NetworkCheckHandler
    public boolean matchModVersions(Map<String, String> remoteVersions, Side side) {
        return remoteVersions.containsKey("UniDict") && remoteVersions.get("UniDict").equals("1.10.2-1.6");
    }

    static {
        dependencies = new Dependencies();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Module {
    }

    public static interface IDependence {
    }
}

