/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.ResourceHandler;

public final class MetaItem {
    public static final FMLControlledNamespacedRegistry<Item> itemRegistry = (FMLControlledNamespacedRegistry)GameRegistry.findRegistry(Item.class);

    private MetaItem() {
    }

    public static int get(ItemStack itemStack) {
        Item item;
        if (itemStack == null || (item = itemStack.func_77973_b()) == null) {
            return 0;
        }
        int id = itemRegistry.getId((IForgeRegistryEntry)item);
        return id > 0 ? id | item.getDamage(itemStack) + 1 << 16 : 0;
    }

    public static int get(Item item) {
        if (item == null) {
            return 0;
        }
        int id = itemRegistry.func_148757_b((Object)item);
        return id > 0 ? id | 0x10000 : 0;
    }

    public static ItemStack toItemStack(int metaItemKey) {
        return metaItemKey > 0 ? new ItemStack((Item)itemRegistry.getRaw(metaItemKey ^ metaItemKey & 0x10000), 0, metaItemKey >> 16) : null;
    }

    public static int getCumulative(@Nonnull Object[] objects, @Nonnull ResourceHandler resourceHandler) {
        int cumulativeKey = 0;
        for (Object object : objects) {
            if (object instanceof ItemStack) {
                cumulativeKey += MetaItem.get(resourceHandler.getMainItemStack((ItemStack)object));
                continue;
            }
            if (!(object instanceof List) || ((List)object).isEmpty()) continue;
            cumulativeKey += MetaItem.get((ItemStack)((List)object).get(0));
        }
        return cumulativeKey;
    }

    public static int getCumulative(ItemStack ... itemStacks) {
        int cumulativeKey = 0;
        for (ItemStack itemStack : itemStacks) {
            cumulativeKey += MetaItem.get(itemStack);
        }
        return cumulativeKey;
    }

    public static int[] getArray(@Nonnull Collection<ItemStack> itemStackCollection) {
        return MetaItem.getList(itemStackCollection).toArray();
    }

    public static TIntList getList(@Nonnull Collection<ItemStack> itemStackCollection) {
        TIntArrayList keys = new TIntArrayList();
        for (ItemStack itemStack : itemStackCollection) {
            int hash = MetaItem.get(itemStack);
            if (hash == 0) continue;
            keys.add(hash);
        }
        return keys;
    }

    public static TIntSet getSet(@Nonnull Collection<Resource> resourceCollection, long kind) {
        TIntHashSet keys = new TIntHashSet();
        resourceCollection.stream().filter(resource -> (resource.getChildren() & kind) > 0L).forEach(arg_0 -> MetaItem.lambda$getSet$1((TIntSet)keys, kind, arg_0));
        return keys;
    }

    public static TIntSet getSet(@Nonnull Collection<ItemStack> itemStackCollection) {
        return new TIntHashSet((TIntCollection)MetaItem.getList(itemStackCollection));
    }

    public static <E> void populateMap(@Nonnull Collection<ItemStack> itemStackCollection, @Nonnull TIntObjectMap<E> map, E defaultValue) {
        for (int id : MetaItem.getArray(itemStackCollection)) {
            map.put(id, defaultValue);
        }
    }

    public static void populateMap(@Nonnull Collection<ItemStack> itemStackCollection, @Nonnull TIntLongMap map, long defaultValue) {
        for (int id : MetaItem.getArray(itemStackCollection)) {
            map.put(id, defaultValue);
        }
    }

    private static /* synthetic */ void lambda$getSet$1(TIntSet keys, long kind, Resource resource) {
        keys.addAll((TIntCollection)MetaItem.getList(resource.getChild(kind).getEntries()));
    }
}

