/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Handlers.Handler
public class RightClickCropHandler {
    private List<PlantInfo> plants = Lists.newArrayList();
    private PlantInfo currentPlant = null;
    public static final RightClickCropHandler INSTANCE = new RightClickCropHandler();

    private RightClickCropHandler() {
    }

    public void addCrop(PlantInfo info) {
        this.plants.add(info);
    }

    @SubscribeEvent
    public void handleCropRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        if (pos == null) {
            return;
        }
        IBlockState blockState = event.getWorld().func_180495_p(pos);
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        if (ConfigHandler.allowCropRC && (event.getEntityPlayer().func_184614_ca() == null || !event.getEntityPlayer().func_70093_af())) {
            for (PlantInfo info : this.plants) {
                if (info.blockInst != block || meta != info.meta) continue;
                if (event.getWorld().field_72995_K) {
                    event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                    break;
                }
                this.currentPlant = info;
                block.func_176226_b(event.getWorld(), pos, blockState, 0);
                this.currentPlant = null;
                IBlockState newBS = block.func_176203_a(info.resetMeta);
                event.getWorld().func_180501_a(pos, newBS, 3);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDrop(BlockEvent.HarvestDropsEvent event) {
        if (this.currentPlant != null) {
            for (int i = 0; i < event.getDrops().size(); ++i) {
                ItemStack stack = (ItemStack)event.getDrops().get(i);
                if (stack.func_77973_b() != this.currentPlant.seedStack.func_77973_b() || this.currentPlant.seedStack.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != this.currentPlant.seedStack.func_77952_i()) continue;
                event.getDrops().remove(i);
                break;
            }
        }
    }

    public static class PlantInfo {
        public String seed;
        public String block;
        public int meta = 7;
        public int resetMeta = 0;
        private transient ItemStack seedStack;
        private transient Block blockInst;

        public PlantInfo() {
        }

        public PlantInfo(String seed, String block, int meta, int resetMeta) {
            this.seed = seed;
            this.block = block;
            this.meta = meta;
            this.resetMeta = resetMeta;
        }

        public void init() {
            this.seedStack = ItemUtil.parseStringIntoItemStack(this.seed);
            String[] blockinfo = this.block.split(":");
            this.blockInst = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockinfo[0], blockinfo[1]));
        }
    }
}

