/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.IHideable;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TextFieldEnder
extends GuiTextField
implements IHideable {
    public static final ICharFilter FILTER_NUMERIC = new ICharFilter(){

        @Override
        public boolean passesFilter(TextFieldEnder tf, char c) {
            return Character.isDigit(c) || c == '-' && Strings.isNullOrEmpty((String)tf.func_146179_b());
        }
    };
    public static ICharFilter FILTER_ALPHABETICAL = new ICharFilter(){

        @Override
        public boolean passesFilter(TextFieldEnder tf, char c) {
            return Character.isLetter(c);
        }
    };
    public static ICharFilter FILTER_ALPHANUMERIC = new ICharFilter(){

        @Override
        public boolean passesFilter(TextFieldEnder tf, char c) {
            return FILTER_NUMERIC.passesFilter(tf, c) || FILTER_ALPHABETICAL.passesFilter(tf, c);
        }
    };
    private int xOrigin;
    private int yOrigin;
    private ICharFilter filter;
    private static Field canLoseFocus;

    public TextFieldEnder(FontRenderer fnt, int x, int y, int width, int height) {
        this(fnt, x, y, width, height, null);
    }

    public TextFieldEnder(FontRenderer fnt, int x, int y, int width, int height, ICharFilter charFilter) {
        super(0, fnt, x, y, width, height);
        this.xOrigin = x;
        this.yOrigin = y;
        this.filter = charFilter;
    }

    public void init(IGuiScreen gui) {
        this.field_146209_f = this.xOrigin + gui.getGuiLeft();
        this.field_146210_g = this.yOrigin + gui.getGuiTop();
    }

    public TextFieldEnder setCharFilter(ICharFilter filter) {
        this.filter = filter;
        return this;
    }

    public boolean func_146201_a(char c, int key) {
        if (this.filter == null || this.filter.passesFilter(this, c) || TextFieldEnder.isSpecialChar(c, key)) {
            return super.func_146201_a(c, key);
        }
        return false;
    }

    public static boolean isSpecialChar(char c, int key) {
        return c == '\u0001' || c == '\u0003' || c == '\u0016' || c == '\u0018' || key == 14 || key == 199 || key == 203 || key == 205 || key == 207 || key == 211;
    }

    public boolean getCanLoseFocus() {
        try {
            return canLoseFocus.getBoolean(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(int x, int y) {
        return x >= this.field_146209_f && x < this.field_146209_f + this.field_146218_h && y >= this.field_146210_g && y < this.field_146210_g + this.field_146219_i;
    }

    @Override
    public boolean isVisible() {
        return this.func_146176_q();
    }

    @Override
    public void setIsVisible(boolean visible) {
        this.func_146189_e(visible);
    }

    public void setXOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public void setYOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }

    static {
        try {
            canLoseFocus = ReflectionHelper.findField(GuiTextField.class, (String[])new String[]{"canLoseFocus", "field_146212_n", "n"});
            canLoseFocus.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ICharFilter {
        public boolean passesFilter(TextFieldEnder var1, char var2);
    }
}

