/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import com.google.common.collect.ImmutableMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.inventory.InventoryLoopBack;
import shetiphian.multistorage.common.inventory.InventoryStacking;
import shetiphian.multistorage.common.tileentity.TileEntityStorageBase;

public class TileEntityStacking
extends TileEntityStorageBase {
    private int numPlayersUsing;
    private final IAnimationStateMachine asm;
    private final TimeValues.VariableValue clickTime = new TimeValues.VariableValue(Float.NEGATIVE_INFINITY);

    public TileEntityStacking() {
        this.asm = MultiStorage.proxy.load(new ResourceLocation("multistorage".toLowerCase(), "armatures/asm_stacking.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)new TimeValues.VariableValue(2.0f), (Object)"click_time", (Object)this.clickTime));
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            if (this.numPlayersUsing < 1 && value > 0) {
                this.animateOpen();
            } else if (this.numPlayersUsing > 0 && value < 1) {
                this.animateClose();
            }
            this.numPlayersUsing = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == CapabilityAnimation.ANIMATION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper(this.getMultiBlockInventory());
        }
        return super.getCapability(capability, side);
    }

    public void handleEvents(Iterable<Event> pastEvents) {
        for (Event event : pastEvents) {
            if (!event.event().equals("status:open") || this.numPlayersUsing >= 1) continue;
            this.animateClose();
        }
    }

    private void animateOpen() {
        if (this.asm != null && this.asm.currentState().equals("closed")) {
            float time = Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime());
            this.clickTime.setValue(time);
            this.asm.transition("opening");
        }
    }

    private void animateClose() {
        if (this.numPlayersUsing < 1 && this.asm != null && this.asm.currentState().equals("open")) {
            this.clickTime.setValue(Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime()));
            this.asm.transition("closing");
        }
    }

    @Override
    public int getChestSize() {
        return 27;
    }

    @Override
    public void onContainerOpen(EntityPlayer player) {
        super.onContainerOpen(player);
        if (!player.func_175149_v()) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
            this.animateOpen();
        }
    }

    @Override
    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        if (!player.func_175149_v()) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
            this.animateClose();
        }
    }

    @Override
    public int func_70302_i_() {
        return this.getMultiBlockInventory().func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int slotId) {
        return this.getMultiBlockInventory().func_70301_a(slotId);
    }

    @Override
    public ItemStack func_70298_a(int slotId, int amount) {
        return this.getMultiBlockInventory().func_70298_a(slotId, amount);
    }

    @Override
    public ItemStack func_70304_b(int slotId) {
        return this.getMultiBlockInventory().func_70304_b(slotId);
    }

    @Override
    public void func_70299_a(int slotId, ItemStack stack) {
        this.getMultiBlockInventory().func_70299_a(slotId, stack);
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.getMultiBlockInventory().func_70300_a(entityPlayer);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        this.getMultiBlockInventory().func_174889_b(player);
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        this.getMultiBlockInventory().func_174886_c(player);
    }

    private IInventory getMultiBlockInventory() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
        if (type != BlockStorageType.EnumType.STACKABLE_SINGLE) {
            IInventory[] inventories = new IInventory[3];
            if (type == BlockStorageType.EnumType.STACKABLE_MIDDLE) {
                inventories[0] = this.getInventory(this.func_174877_v().func_177984_a());
                inventories[1] = this.inventory;
                inventories[2] = this.getInventory(this.func_174877_v().func_177977_b());
            } else if (type == BlockStorageType.EnumType.STACKABLE_TOP) {
                inventories[0] = this.inventory;
                inventories[1] = this.getInventory(this.func_174877_v().func_177977_b());
                inventories[2] = BlockStorageType.getEnumType(this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b())) == BlockStorageType.EnumType.STACKABLE_MIDDLE ? this.getInventory(this.func_174877_v().func_177979_c(2)) : null;
            } else if (type == BlockStorageType.EnumType.STACKABLE_BOTTOM) {
                inventories[0] = BlockStorageType.getEnumType(this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a())) == BlockStorageType.EnumType.STACKABLE_MIDDLE ? this.getInventory(this.func_174877_v().func_177981_b(2)) : null;
                inventories[1] = this.getInventory(this.func_174877_v().func_177984_a());
                inventories[2] = this.inventory;
            }
            return new InventoryStacking(inventories[0], inventories[1], inventories[2]);
        }
        return new InventoryLoopBack((IInventory)this.inventory);
    }

    private IInventory getInventory(BlockPos pos) {
        TileEntity tile = this.func_145831_w().func_175625_s(pos);
        return tile instanceof TileEntityStacking ? ((TileEntityStacking)tile).inventory : null;
    }

    public static IInventory getMultiBlockInventory(TileEntity top, TileEntity middle, TileEntity bottom) {
        return new InventoryStacking(TileEntityStacking.getInventory(top), TileEntityStacking.getInventory(middle), TileEntityStacking.getInventory(bottom));
    }

    private static IInventory getInventory(TileEntity tile) {
        return tile instanceof TileEntityStacking ? ((TileEntityStacking)tile).inventory : null;
    }
}

