/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.enderlink;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLink;

public class ChestInfoHelper {
    private static final ChestInfoHelper INSTANCE = new ChestInfoHelper();

    public static void wailaGetTankInfo(List<String> tooltip, TileEntityEnderLink tile) {
        if (tile == null) {
            return;
        }
        tooltip.add(ChestInfoHelper.formatChestOwner(tile.getOwnerName(), true));
    }

    public static void sendCapacityInfo(EntityPlayer player, TileEntityEnderLink tankTile) {
        String message = INSTANCE.localize("info.multistorage.chest.capacity.txt");
        message = message + " " + ChestHelper.getCapacity(player.field_70170_p, tankTile.getOwnerID(), tankTile.getCode());
        INSTANCE.sendInfo(player, message);
    }

    public static void sendLinkError(EntityPlayer player, int error) {
        String message = "\u00a7c" + INSTANCE.localize("error.multistorage.bag.nolink" + error + ".txt\u00a7r");
        INSTANCE.sendInfo(player, message);
    }

    public static String formatChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            return displayPublic ? " \u00a76[-" + INSTANCE.localize("info.multistorage.chest.public.txt") + "-]\u00a7r" : "";
        }
        return " \u00a7b[-" + owner + "-]\u00a7r";
    }

    private String localize(String string) {
        return I18n.func_74838_a((String)string);
    }

    private void sendInfo(EntityPlayer player, String message) {
        if (player instanceof EntityPlayerMP) {
            message = message.replace("<br>", " ");
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentString(message), 2));
        } else {
            String[] split;
            for (String line : split = message.split("<br>")) {
                player.func_146105_b((ITextComponent)new TextComponentString(line));
            }
        }
    }
}

