/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.enderlink;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.enderlink.ChestData;

public class ChestHelper {
    private static final Table<String, String, ChestData> DATABASE = HashBasedTable.create();
    private static final Table<String, String, ChestData> CLIENTCACHE = HashBasedTable.create();

    private static ChestData getChestData(String owner, String code, boolean isClient) {
        ChestData chestData = isClient ? (ChestData)CLIENTCACHE.get((Object)owner.toLowerCase(), (Object)code.toUpperCase()) : (ChestData)DATABASE.get((Object)owner.toLowerCase(), (Object)code.toUpperCase());
        if (chestData == null) {
            chestData = new ChestData(owner, code);
            ChestHelper.putChestData(owner, code, chestData, isClient);
        }
        return chestData;
    }

    private static void putChestData(String owner, String code, ChestData data, boolean isClient) {
        if (isClient) {
            CLIENTCACHE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)data);
        } else {
            DATABASE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)data);
        }
    }

    public static IInventory getChest(World world, String owner, String code) {
        return ChestHelper.getChestData(owner, code, world.field_72995_K);
    }

    public static void setWantedChest(EntityPlayer player, String owner, String code) {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74778_a("Owner", owner);
        nbtTag.func_74778_a("Code", code);
        player.getEntityData().func_74782_a("LastEnderLink", (NBTBase)nbtTag);
    }

    public static IInventory getWantedChest(EntityPlayer player) {
        if (player.getEntityData().func_74764_b("LastEnderLink")) {
            NBTTagCompound nbtTag = player.getEntityData().func_74775_l("LastEnderLink");
            String owner = nbtTag.func_74779_i("Owner");
            String code = nbtTag.func_74779_i("Code");
            return ChestHelper.getChest(player.field_70170_p, owner, code);
        }
        return null;
    }

    public static String getWantedChestOwner(EntityPlayer player) {
        if (player.getEntityData().func_74764_b("LastEnderLink")) {
            NBTTagCompound nbtTag = player.getEntityData().func_74775_l("LastEnderLink");
            String name = nbtTag.func_74779_i("Owner");
            UUID uuid = null;
            try {
                uuid = UUID.fromString(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return uuid != null && UsernameCache.containsUUID((UUID)uuid) ? UsernameCache.getLastKnownUsername((UUID)uuid) : name;
        }
        return "";
    }

    public static short getCapacity(World world, String owner, String code) {
        return ChestHelper.getChestData(owner, code, world.field_72995_K).getCapacity();
    }

    public static void setCapacity(World world, String owner, String code, byte capacity) {
        ChestHelper.getChestData(owner, code, world.field_72995_K).setCapacity(capacity);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (event.getWorld() == null || event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            NBTTagCompound fileNBT = new NBTTagCompound();
            for (Map.Entry pocket : networkMap.entrySet()) {
                if (!((ChestData)pocket.getValue()).saveCheck()) continue;
                NBTTagCompound nbtPocket = ((ChestData)pocket.getValue()).writeToNBT(new NBTTagCompound());
                fileNBT.func_74782_a((String)pocket.getKey(), (NBTBase)nbtPocket);
            }
            try {
                FileOutputStream fileoutputstream = new FileOutputStream(this.getSaveFile(event.getWorld(), owner));
                CompressedStreamTools.func_74799_a((NBTTagCompound)fileNBT, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (event.getWorld() == null || event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        DATABASE.clear();
        List<File> fileList = this.getSaveFiles(event.getWorld());
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", ""));
            NBTTagCompound fileNBT = this.getNBTTag(file);
            for (String code : fileNBT.func_150296_c()) {
                ChestHelper.putChestData(owner, code, new ChestData(owner, code).loadFromNBT(fileNBT.func_74775_l(code)), false);
            }
        }
    }

    private List<File> getSaveFiles(World world) {
        ArrayList<File> fileList = new ArrayList<File>();
        String saveDir = MultiStorage.proxy.getSaveDir(world, Values.minecraftDir) + "/enderchests";
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(World world, String owner) {
        String saveDir = MultiStorage.proxy.getSaveDir(world, Values.minecraftDir) + "/enderchests";
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                Values.logMultiStorage.error("Could Not Read or Create File: " + file.toString(), (Throwable)error);
            }
        }
        return file;
    }

    private NBTTagCompound getNBTTag(File file) {
        NBTTagCompound nbtData = new NBTTagCompound();
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            nbtData = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nbtData;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }
}

