/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.enderlink;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import shetiphian.multistorage.Settings;

class ChestData
implements IInventory {
    private ItemStack[] contents = new ItemStack[54];
    private byte capacity = (byte)9;
    private final String owner;
    private final String code;

    ChestData(String owner, String code) {
        this.owner = owner.toLowerCase();
        this.code = code.toLowerCase();
    }

    short getCapacity() {
        return (short)MathHelper.func_76125_a((int)this.capacity, (int)Settings.INSTANCE.chestSizeMin, (int)Settings.INSTANCE.chestSizeMax);
    }

    void setCapacity(byte capacity) {
        this.capacity = (byte)MathHelper.func_76125_a((int)capacity, (int)Settings.INSTANCE.chestSizeMin, (int)Settings.INSTANCE.chestSizeMax);
    }

    NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        NBTTagList nbtList = new NBTTagList();
        for (int index = 0; index < this.contents.length; ++index) {
            if (this.contents[index] == null) continue;
            NBTTagCompound nbtCompound = new NBTTagCompound();
            nbtCompound.func_74774_a("Slot", (byte)index);
            this.contents[index].func_77955_b(nbtCompound);
            nbtList.func_74742_a((NBTBase)nbtCompound);
        }
        nbtTag.func_74782_a("Items", (NBTBase)nbtList);
        nbtTag.func_74774_a("Capacity", this.capacity);
        return nbtTag;
    }

    ChestData loadFromNBT(NBTTagCompound nbtTag) {
        this.setCapacity(nbtTag.func_74771_c("Capacity"));
        NBTTagList nbtList = nbtTag.func_150295_c("Items", 10);
        for (int index = 0; index < nbtList.func_74745_c(); ++index) {
            NBTTagCompound nbtCompound = nbtList.func_150305_b(index);
            int slot = nbtCompound.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.func_77949_a((NBTTagCompound)nbtCompound);
        }
        return this;
    }

    boolean saveCheck() {
        if (this.capacity > Settings.INSTANCE.chestSizeMin) {
            return true;
        }
        for (ItemStack content : this.contents) {
            if (content == null) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.getCapacity();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.contents[slotId];
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        if (this.contents[slotId] != null) {
            if (this.contents[slotId].field_77994_a <= amount) {
                ItemStack stack = this.contents[slotId];
                this.contents[slotId] = null;
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = this.contents[slotId].func_77979_a(amount);
            if (this.contents[slotId].field_77994_a == 0) {
                this.contents[slotId] = null;
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotId) {
        ItemStack returnStack = this.func_70301_a(slotId);
        this.func_70299_a(slotId, null);
        return returnStack;
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        this.contents[slotId] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return this.getCapacity();
    }

    public void func_174885_b(int id, int value) {
        this.setCapacity((byte)value);
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        this.contents = new ItemStack[54];
    }

    public String func_70005_c_() {
        return this.code + "." + this.owner;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

