/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.IColored;
import shetiphian.core.common.block.properties.UnlistedPropertyIBlockState;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.common.block.IStorageType;
import shetiphian.multistorage.common.block.TypeChameleon;
import shetiphian.multistorage.common.block.TypeJunkbox;
import shetiphian.multistorage.common.block.TypeStacking;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;
import shetiphian.multistorage.common.tileentity.TileEntityChameleonDense;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;
import shetiphian.multistorage.common.tileentity.TileEntityJunkboxDense;
import shetiphian.multistorage.common.tileentity.TileEntityStacking;
import shetiphian.multistorage.common.tileentity.TileEntityStackingDense;
import shetiphian.multistorage.common.tileentity.TileEntityStorageBase;

public abstract class BlockStorageType
extends Block
implements IColored {
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final IStorageType STACKING = new TypeStacking();
    public static final IStorageType CHAMELEON = new TypeChameleon();
    public static final IStorageType JUNKBOX = new TypeJunkbox();
    public static final UnlistedPropertyIBlockState EIBS = UnlistedPropertyIBlockState.create((String)"eibs");

    public BlockStorageType(Material material) {
        super(material);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{VARIANT, FACING, Properties.StaticProperty}, new IUnlistedProperty[]{EIBS, Properties.AnimationProperty});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() != this) {
            return EnumType.CHAMELEON.getValue();
        }
        return BlockStorageType.getEnumType(state).getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(true));
        TileEntityStorageBase tile = this.getTile(world, pos);
        if (tile != null) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)tile.getFacing());
        }
        if (tile instanceof TileEntityJunkbox) {
            TileEntityJunkbox junkbox = (TileEntityJunkbox)tile;
            EnumType type = junkbox instanceof TileEntityJunkboxDense ? (junkbox.isDouble() ? EnumType.DENSE_JUNKBOX_DOUBLE : (junkbox.isTop() ? EnumType.DENSE_JUNKBOX_TOP : EnumType.DENSE_JUNKBOX_BOTTOM)) : (junkbox.isDouble() ? EnumType.JUNKBOX_DOUBLE : (junkbox.isTop() ? EnumType.JUNKBOX_TOP : EnumType.JUNKBOX_BOTTOM));
            state = state.func_177226_a(VARIANT, (Comparable)((Object)type));
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityStorageBase tile = this.getTile(world, pos);
        IExtendedBlockState estate = (IExtendedBlockState)state;
        if (tile instanceof TileEntityChameleon) {
            TileEntityChameleon chameleon = (TileEntityChameleon)tile;
            IBlockState cloned = chameleon.getClonedState();
            if (!(cloned.func_177230_c() instanceof BlockStorageType)) {
                cloned = cloned.func_177230_c().getExtendedState(cloned, (IBlockAccess)chameleon.func_145831_w(), chameleon.getClonedPos());
            }
            estate = estate.withProperty((IUnlistedProperty)EIBS, (Object)cloned);
        }
        return estate;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumType type = BlockStorageType.getEnumType(state);
        switch (type) {
            case STACKABLE_SINGLE: 
            case STACKABLE_TOP: 
            case STACKABLE_MIDDLE: 
            case STACKABLE_BOTTOM: {
                return new TileEntityStacking();
            }
            case CHAMELEON: {
                return new TileEntityChameleon();
            }
            case JUNKBOX_TOP: 
            case JUNKBOX_BOTTOM: 
            case JUNKBOX_DOUBLE: {
                return new TileEntityJunkbox();
            }
            case DENSE_STACKABLE_SINGLE: 
            case DENSE_STACKABLE_TOP: 
            case DENSE_STACKABLE_MIDDLE: 
            case DENSE_STACKABLE_BOTTOM: {
                return new TileEntityStackingDense();
            }
            case DENSE_CHAMELEON: {
                return new TileEntityChameleonDense();
            }
            case DENSE_JUNKBOX_TOP: 
            case DENSE_JUNKBOX_BOTTOM: 
            case DENSE_JUNKBOX_DOUBLE: {
                return new TileEntityJunkboxDense();
            }
        }
        return null;
    }

    private TileEntityStorageBase getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityStorageBase ? (TileEntityStorageBase)tile : null;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return super.canHarvestBlock(world, pos, player);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IStorageType helper = BlockStorageType.getHelper(state);
        if (helper != null) {
            return helper.getBoxBounds(this, state, world, pos);
        }
        return Block.field_185505_j;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        IStorageType helper = BlockStorageType.getHelper(world.func_180495_p(pos));
        if (helper == null || !helper.addCollisionBoxesToList(world, pos, state, aabb, list, entity)) {
            super.func_185477_a(state, world, pos, aabb, list, entity);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityStorageBase) {
            ((TileEntityStorageBase)tile).dropItems();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IStorageType helper = BlockStorageType.getHelper(state);
        if (helper != null) {
            helper.onBlockRemoved(world, pos, player);
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (world.func_180495_p(pos).func_177230_c() == this) {
            state = this.func_176221_a(state, world, pos);
        }
        EnumType type = BlockStorageType.getEnumType(state);
        switch (type) {
            case STACKABLE_SINGLE: 
            case STACKABLE_TOP: 
            case STACKABLE_MIDDLE: 
            case STACKABLE_BOTTOM: {
                ret.add(new ItemStack((Block)this, 1, 1));
                break;
            }
            case DENSE_STACKABLE_SINGLE: 
            case DENSE_STACKABLE_TOP: 
            case DENSE_STACKABLE_MIDDLE: 
            case DENSE_STACKABLE_BOTTOM: {
                ret.add(new ItemStack((Block)this, 1, 2));
                break;
            }
            case CHAMELEON: {
                ret.add(new ItemStack((Block)this, 1, 3));
                break;
            }
            case DENSE_CHAMELEON: {
                ret.add(new ItemStack((Block)this, 1, 4));
                break;
            }
            case JUNKBOX_TOP: 
            case JUNKBOX_BOTTOM: {
                ret.add(new ItemStack((Block)this, 1, 5));
                break;
            }
            case JUNKBOX_DOUBLE: {
                ret.add(new ItemStack((Block)this, 2, 5));
                break;
            }
            case DENSE_JUNKBOX_TOP: 
            case DENSE_JUNKBOX_BOTTOM: {
                ret.add(new ItemStack((Block)this, 1, 6));
                break;
            }
            case DENSE_JUNKBOX_DOUBLE: {
                ret.add(new ItemStack((Block)this, 1, 6));
                ret.add(new ItemStack((Block)this, 1, 5));
            }
        }
        return ret;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IStorageType helper = BlockStorageType.getHelper(state);
        return helper == null || helper.isSideSolid(world, pos, side);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IStorageType helper = BlockStorageType.getHelper(state);
        return helper != null && helper.onBlockActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IStorageType helper = BlockStorageType.getHelper(world.func_180495_p(pos));
        return helper != null && helper.rotateBlock(world, pos, axis);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        IStorageType helper = BlockStorageType.getHelper(world.func_180495_p(pos));
        return helper != null ? helper.getEnchantPowerBonus(world, pos) : 0.0f;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IStorageType helper = BlockStorageType.getHelper(state);
        return helper != null ? helper.getLightValue(world, pos) : 0;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        IStorageType helper = BlockStorageType.getHelper(state);
        return helper != null ? helper.getLightOpacity(world, pos) : 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        IStorageType helper = BlockStorageType.getHelper(state);
        return helper != null ? helper.canRenderInLayer(state, layer) : layer == BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        IStorageType helper;
        if (data.state != null && data.world != null && data.pos != null && (helper = BlockStorageType.getHelper(data.state)) != null) {
            return helper.colorMultiplier(data.world, data.pos, index);
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        EnumType type = BlockStorageType.getEnumType(state);
        switch (type) {
            case STACKABLE_SINGLE: 
            case STACKABLE_TOP: 
            case STACKABLE_MIDDLE: 
            case STACKABLE_BOTTOM: {
                return new ItemStack((Block)this, 1, 1);
            }
            case DENSE_STACKABLE_SINGLE: 
            case DENSE_STACKABLE_TOP: 
            case DENSE_STACKABLE_MIDDLE: 
            case DENSE_STACKABLE_BOTTOM: {
                return new ItemStack((Block)this, 1, 2);
            }
            case CHAMELEON: 
            case DENSE_CHAMELEON: {
                TileEntityStorageBase tile = this.getTile((IBlockAccess)world, pos);
                if (player != null && player.field_71075_bZ.field_75098_d || !(tile instanceof TileEntityChameleon)) {
                    if (type == EnumType.CHAMELEON) {
                        return new ItemStack((Block)this, 1, 3);
                    }
                    return new ItemStack((Block)this, 1, 4);
                }
                TileEntityChameleon tileEntityChameleon = (TileEntityChameleon)tile;
                Block block = tileEntityChameleon.getClonedBlock();
                if (block == null || block == this) break;
                return block.getPickBlock(tileEntityChameleon.getClonedState(), new RayTraceResult(target.field_72307_f, target.field_178784_b, tileEntityChameleon.getClonedPos()), world, tileEntityChameleon.getClonedPos(), player);
            }
            case JUNKBOX_TOP: 
            case JUNKBOX_BOTTOM: 
            case JUNKBOX_DOUBLE: {
                return new ItemStack((Block)this, 1, 5);
            }
            case DENSE_JUNKBOX_TOP: 
            case DENSE_JUNKBOX_BOTTOM: 
            case DENSE_JUNKBOX_DOUBLE: {
                return new ItemStack((Block)this, 1, 6);
            }
        }
        return null;
    }

    private static IStorageType getHelper(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStorageType) {
            switch (BlockStorageType.getEnumType(state)) {
                case STACKABLE_SINGLE: 
                case STACKABLE_TOP: 
                case STACKABLE_MIDDLE: 
                case STACKABLE_BOTTOM: 
                case DENSE_STACKABLE_SINGLE: 
                case DENSE_STACKABLE_TOP: 
                case DENSE_STACKABLE_MIDDLE: 
                case DENSE_STACKABLE_BOTTOM: {
                    return STACKING;
                }
                case CHAMELEON: 
                case DENSE_CHAMELEON: {
                    return CHAMELEON;
                }
                case JUNKBOX_TOP: 
                case JUNKBOX_BOTTOM: 
                case JUNKBOX_DOUBLE: 
                case DENSE_JUNKBOX_TOP: 
                case DENSE_JUNKBOX_BOTTOM: 
                case DENSE_JUNKBOX_DOUBLE: {
                    return JUNKBOX;
                }
            }
        }
        return null;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.STACKABLE_SINGLE;
            MultiStorage.errorPropertyNotFound("BlockStorageType.VARIANT", "STACKABLE_SINGLE", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        STACKABLE_SINGLE(0, false),
        STACKABLE_TOP(1, false),
        STACKABLE_MIDDLE(2, false),
        STACKABLE_BOTTOM(3, false),
        CHAMELEON(4, false),
        JUNKBOX_TOP(5, false),
        JUNKBOX_BOTTOM(5, false),
        JUNKBOX_DOUBLE(5, false),
        DENSE_STACKABLE_SINGLE(8, true),
        DENSE_STACKABLE_TOP(9, true),
        DENSE_STACKABLE_MIDDLE(10, true),
        DENSE_STACKABLE_BOTTOM(11, true),
        DENSE_CHAMELEON(12, true),
        DENSE_JUNKBOX_TOP(13, true),
        DENSE_JUNKBOX_BOTTOM(13, true),
        DENSE_JUNKBOX_DOUBLE(13, true);

        private static final EnumType[] array;
        private final byte value;
        private final boolean dense;

        private EnumType(int value, boolean dense) {
            this.value = (byte)value;
            this.dense = dense;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? STACKABLE_SINGLE : type;
        }

        public boolean isDense() {
            return this.dense;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            for (EnumType value : EnumType.values()) {
                if (array[value.getValue()] != null) continue;
                EnumType.array[value.getValue()] = value;
            }
        }
    }
}

