/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.misc;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.client.gui.GuiChameleon;
import shetiphian.multistorage.client.gui.GuiCorer;
import shetiphian.multistorage.client.gui.GuiEnderLink;
import shetiphian.multistorage.client.gui.GuiEnderPocket;
import shetiphian.multistorage.client.gui.GuiJunkbox;
import shetiphian.multistorage.client.gui.GuiStacking;
import shetiphian.multistorage.client.gui.GuiVault;
import shetiphian.multistorage.client.misc.ConfigGUIHandler;
import shetiphian.multistorage.client.misc.EventHandlerClient;
import shetiphian.multistorage.client.renderer.RenderRegistry;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.inventory.ContainerChameleon;
import shetiphian.multistorage.common.inventory.ContainerStacking;
import shetiphian.multistorage.common.misc.ProxyCommon;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLink;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;
import shetiphian.multistorage.common.tileentity.TileEntityVaultCorer;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;

public class ProxyClient
extends ProxyCommon {
    @Override
    public void setupConfig(File file) {
        super.setupConfig(file);
        MinecraftForge.EVENT_BUS.register((Object)ConfigGUIHandler.INSTANCE);
    }

    @Override
    public void renderingPreInt() {
        RenderRegistry.renderingPreInt();
    }

    @Override
    public void renderingInt() {
        RenderRegistry.renderingInt();
    }

    @Override
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
        super.registerEventHandlers();
    }

    @Override
    public IAnimationStateMachine load(ResourceLocation location, ImmutableMap<String, ITimeValue> parameters) {
        return ModelLoaderRegistry.loadASM((ResourceLocation)location, parameters);
    }

    @Override
    public String getSaveDir(World world, String minecraftDir) {
        return world.field_72995_K ? minecraftDir + "/temp" : minecraftDir + "/saves/" + world.func_72860_G().func_75765_b().getName();
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        switch (id) {
            case 0: {
                return new GuiVault(player, (TileEntityVaultDoor)tile);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Object chest = this.getServerGuiElement(id, player, world, x, y, z);
                if (!(chest instanceof ContainerStacking)) break;
                return new GuiStacking((ContainerStacking)((Object)chest), tile.func_145838_q() == Values.blockCloudStorage);
            }
            case 5: {
                return new GuiChameleon(new ContainerChameleon(player, (TileEntityChameleon)tile), (TileEntityChameleon)tile);
            }
            case 6: {
                return new GuiEnderPocket(player);
            }
            case 7: {
                return new GuiEnderLink(player, (TileEntityEnderLink)tile, ((TileEntityEnderLink)tile).getOwnerName());
            }
            case 8: {
                return new GuiEnderLink(player, ChestHelper.getWantedChest(player), ChestHelper.getWantedChestOwner(player));
            }
            case 9: {
                return new GuiJunkbox(player, (TileEntityJunkbox)tile, tile.func_145838_q() == Values.blockCloudStorage);
            }
            case 10: {
                return new GuiCorer(player.field_71071_by, (TileEntityVaultCorer)tile);
            }
        }
        return null;
    }
}

