/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.CommandBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.multistorage.client.gui.SlotVaultList;
import shetiphian.multistorage.common.block.VaultHelper;
import shetiphian.multistorage.common.misc.UUIDHelper;
import shetiphian.multistorage.common.network.NetworkHandler;
import shetiphian.multistorage.common.network.PacketVault;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;

public class GuiVault
extends GuiScreen {
    static final ResourceLocation textureGUIVault = new ResourceLocation("multistorage", "textures/gui/vault.png");
    protected TileEntityVaultDoor tile;
    private SlotVaultList nameList;
    private boolean fullAccess;
    private boolean inVAC = false;
    private boolean inRFR = false;
    private int xSize;
    private int ySize;
    GuiTextField guiTextField;

    public GuiVault(EntityPlayer player, TileEntityVaultDoor tile) {
        this.tile = tile;
        this.xSize = 256;
        this.fullAccess = tile.vaultAccess.hasFullAccess(player);
        this.inVAC = !this.fullAccess;
    }

    public void func_73866_w_() {
        this.ySize = this.inVAC ? 188 : 60;
        int cX = this.field_146294_l / 2;
        int winTop = (this.field_146295_m - this.ySize) / 2;
        int winLeft = (this.field_146294_l - this.xSize) / 2;
        this.field_146292_n.clear();
        if (this.inVAC) {
            if (this.fullAccess) {
                this.field_146292_n.add(new Button(0, cX - 39, winTop + 151, 78, 20, Localization.get((String)"gui.multistorage.vault.button.add.txt")));
                this.field_146292_n.add(new Button(1, cX - 75, winTop + 151, 78, 20, Localization.get((String)"gui.multistorage.vault.button.remove.txt")));
                this.field_146292_n.add(new Button(2, cX + 5, winTop + 151, 78, 20, Localization.get((String)"gui.multistorage.vault.button.promote.txt")));
                this.field_146292_n.add(new Button(3, cX - 75, winTop + 151, 78, 20, Localization.get((String)"gui.multistorage.vault.button.demote.txt")));
                this.field_146292_n.add(new Button(4, cX + 5, winTop + 151, 78, 20, Localization.get((String)"gui.multistorage.vault.button.owner.txt")));
            } else {
                this.field_146292_n.add(new Button(0, cX - 39, winTop + 151, 78, 20, Localization.get((String)"gui.multistorage.vault.button.add.txt")));
                this.field_146292_n.add(new Button(1, cX - 39, winTop + 151, 78, 20, Localization.get((String)"gui.multistorage.vault.button.remove.txt")));
            }
            this.field_146292_n.add(new Button(5, cX - 119, winTop + 132, 20, 20, "").alwaysActive());
            this.field_146292_n.add(new Button(8, cX + 101, winTop + 132, 20, 20, "").alwaysActive());
            this.guiTextField = new GuiTextField(10, this.field_146289_q, winLeft + 26, winTop + 133, 217, 14);
            this.guiTextField.func_146203_f(36);
            this.nameList = new SlotVaultList(this, winLeft + 14, winTop + 38, 226, 89);
            this.nameList.func_148134_d(4, 5);
        } else if (this.inRFR) {
            this.guiTextField = new GuiTextField(10, this.field_146289_q, cX - 75, winTop + 11, 158, 20);
            this.field_146292_n.add(new Button(6, cX - 75, winTop + this.ySize - 25, 158, 20, Localization.get((String)"gui.multistorage.vault.button.door.txt")));
            this.guiTextField.func_146180_a(Localization.get((String)"gui.multistorage.vault.enterreason.txt"));
            this.guiTextField.func_146203_f(32);
        } else {
            this.field_146292_n.add(new Button(7, cX - 75, winTop + 11, 158, 20, Localization.get((String)"gui.multistorage.vault.button.access.txt")));
            this.field_146292_n.add(new Button(6, cX - 75, winTop + this.ySize - 25, 158, 20, Localization.get((String)"gui.multistorage.vault.button.door.txt")));
        }
        this.setVisibleButtons();
    }

    void setVisibleButtons() {
        if (!this.inVAC) {
            return;
        }
        int selected = this.nameList.getSelectedElement();
        for (GuiButton button : this.field_146292_n) {
            button.field_146124_l = false;
            button.field_146125_m = false;
        }
        if (selected > -1) {
            UUID uuid = this.tile.vaultAccess.getUUID(selected);
            if (!this.tile.vaultAccess.isSuperUser(uuid)) {
                ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = true;
                if (this.fullAccess) {
                    ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = true;
                }
            } else if (this.fullAccess) {
                ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = true;
                ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = true;
            }
        } else {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = true;
        }
        if (this.inVAC) {
            for (GuiButton button : this.field_146292_n) {
                button.field_146125_m = button.field_146124_l;
            }
        }
        for (GuiButton button : this.field_146292_n) {
            if (button.field_146127_k != 5 && button.field_146127_k != 8) continue;
            button.field_146124_l = true;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(textureGUIVault);
        int winLeft = (this.field_146294_l - this.xSize) / 2;
        int winTop = (this.field_146295_m - this.ySize) / 2;
        if (this.inVAC) {
            GuiFunctions.enterDrawTextureStateWithBlend();
            this.func_73729_b(winLeft, winTop + 37, 0, 37, 256, 91);
            GuiFunctions.exitDrawTextureStateWithBlend();
            this.nameList.func_148128_a(mouseX, mouseY, partialTicks);
            this.field_146297_k.func_110434_K().func_110577_a(textureGUIVault);
            GuiFunctions.enterDrawTextureStateWithBlend();
            this.func_73729_b(winLeft, winTop, 0, 0, 256, 37);
            this.func_73729_b(winLeft, winTop + 128, 0, 128, 256, 66);
            GuiFunctions.exitDrawTextureStateWithBlend();
            this.func_73732_a(this.field_146289_q, Localization.get((String)"gui.multistorage.vault.button.access.txt"), this.field_146294_l / 2, winTop + 9, 0xF0F0F0);
            this.func_73732_a(this.field_146289_q, Localization.get((String)"gui.multistorage.vault.access.txt"), this.field_146294_l / 2, winTop + 23, 0xF0F0F0);
            String owner = Localization.get((String)"gui.multistorage.vault.owner.txt") + ": " + this.tile.vaultAccess.getOwnerName();
            this.func_73732_a(this.field_146289_q, owner, this.field_146294_l / 2, winTop + this.ySize - 12, 0xF0F0F0);
            GuiButton buttonFilter = null;
            GuiButton buttonIntruder = null;
            for (GuiButton button : this.field_146292_n) {
                if (button.field_146124_l) {
                    button.func_146112_a(this.field_146297_k, mouseX, mouseY);
                }
                if (button.field_146127_k == 5) {
                    buttonFilter = button;
                    continue;
                }
                if (button.field_146127_k != 8) continue;
                buttonIntruder = button;
            }
            this.guiTextField.func_146194_f();
            ArrayList tooltip = new ArrayList();
            if (buttonFilter != null || buttonIntruder != null) {
                this.field_146297_k.func_110434_K().func_110577_a(textureGUIVault);
                GuiFunctions.enterDrawTextureStateWithBlend();
                if (buttonFilter != null) {
                    this.func_73729_b(buttonFilter.field_146128_h, buttonFilter.field_146129_i, 240, this.tile.vaultAccess.isWhitelist() ? 240 : 224, 16, 16);
                    if (buttonFilter.func_146115_a()) {
                        Localization.multiLine((String)("gui.multistorage.vault.button.filter." + (this.tile.vaultAccess.isWhitelist() ? "white" : "black") + ".txt"), tooltip);
                    }
                }
                if (buttonIntruder != null) {
                    this.func_73729_b(buttonIntruder.field_146128_h, buttonIntruder.field_146129_i, this.tile.vaultAccess.isDefenceKill() ? 240 : (this.tile.vaultAccess.isDefenceEnabled() ? 224 : 208), 208, 16, 16);
                    if (buttonIntruder.func_146115_a()) {
                        Localization.multiLine((String)("gui.multistorage.vault.button.defence." + (this.tile.vaultAccess.isDefenceKill() ? "kill" : (this.tile.vaultAccess.isDefenceEnabled() ? "kick" : "off")) + ".txt"), tooltip);
                    }
                }
                GuiFunctions.exitDrawTextureStateWithBlend();
            }
            if (!tooltip.isEmpty()) {
                GuiFunctions.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (FontRenderer)this.field_146289_q, (GuiScreen)this);
            }
        } else {
            GuiFunctions.enterDrawTextureStateWithBlend();
            this.func_73729_b(winLeft, winTop, 0, 0, 256, 6);
            this.func_73729_b(winLeft, winTop + 6, 0, 135, 256, 59);
            GuiFunctions.exitDrawTextureStateWithBlend();
            GuiFunctions.enterRenderItemState();
            ((GuiButton)this.field_146292_n.get(0)).func_146112_a(this.field_146297_k, mouseX, mouseY);
            if (this.inRFR) {
                this.guiTextField.func_146194_f();
            } else {
                ((GuiButton)this.field_146292_n.get(1)).func_146112_a(this.field_146297_k, mouseX, mouseY);
            }
            GuiFunctions.exitRenderItemState();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button.field_146127_k == 7) {
            this.inVAC = true;
            this.func_73866_w_();
        } else if (button.field_146127_k == 6) {
            if (this.inRFR) {
                String info = !this.guiTextField.func_146179_b().isEmpty() && !this.guiTextField.func_146179_b().equals(Localization.get((String)"gui.multistorage.vault.enterreason.txt")) ? this.guiTextField.func_146179_b() : "???";
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
                NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.REMOVEDOOR, null, info));
            } else {
                this.inRFR = true;
                this.func_73866_w_();
                this.guiTextField.func_146195_b(true);
            }
        } else if (button.field_146127_k == 5) {
            if (this.fullAccess) {
                this.tile.vaultAccess.setWhitelist(!this.tile.vaultAccess.isWhitelist());
                NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.WHITELIST, null, String.valueOf(this.tile.vaultAccess.isWhitelist())));
            }
        } else if (button.field_146127_k == 8) {
            if (this.fullAccess) {
                int defence = (this.tile.vaultAccess.isDefenceKill() ? 0 : (this.tile.vaultAccess.isDefenceEnabled() ? 1 : -1)) + 1;
                if (defence > 1) {
                    defence = -1;
                }
                this.tile.vaultAccess.setDefence(defence);
                NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.DEFENCE, null, "" + defence));
            }
        } else if (button.field_146127_k >= 0 && button.field_146127_k <= 4) {
            String name = this.guiTextField.func_146179_b();
            if (name.trim().isEmpty()) {
                return;
            }
            UUID uuid = UUIDHelper.getCachedUUID(name);
            if (uuid == null) {
                uuid = UUIDHelper.getOfflineUUID(name);
            }
            switch (button.field_146127_k) {
                case 0: {
                    if (this.tile.vaultAccess.contains(uuid)) {
                        return;
                    }
                    this.tile.vaultAccess.add(uuid, name);
                    NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.ADDUSER, uuid, ""));
                    break;
                }
                case 1: {
                    if (!this.tile.vaultAccess.contains(uuid)) {
                        return;
                    }
                    this.tile.vaultAccess.remove(uuid);
                    NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.REMOVEUSER, uuid, ""));
                    break;
                }
                case 2: {
                    if (this.tile.vaultAccess.isSuperUser(uuid)) {
                        return;
                    }
                    this.tile.vaultAccess.makeSuperUser(uuid);
                    NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.ADDSUPERUSER, uuid, ""));
                    break;
                }
                case 3: {
                    if (!this.tile.vaultAccess.isSuperUser(uuid)) {
                        return;
                    }
                    this.tile.vaultAccess.revokeSuperUser(uuid);
                    NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.REMOVESUPERUSER, uuid, ""));
                    break;
                }
                case 4: {
                    if (this.tile.vaultAccess.getOwnerId().equals(uuid)) {
                        return;
                    }
                    this.tile.vaultAccess.setOwner(uuid);
                    NetworkHandler.sendToServer(new PacketVault(this.tile.location, VaultHelper.EnumAction.SETOWNER, uuid, ""));
                }
            }
            this.nameList.setSelectedElement(-1);
            this.setVisibleButtons();
        } else {
            this.nameList.func_148147_a(button);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.inVAC) {
            this.nameList.func_178039_p();
        }
    }

    protected void func_73869_a(char character, int value) {
        if (value == 1) {
            if (this.inVAC) {
                if (this.fullAccess) {
                    this.inVAC = false;
                    this.func_73866_w_();
                    return;
                }
            } else if (this.inRFR) {
                this.inRFR = false;
                this.func_73866_w_();
                return;
            }
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
        if ((this.inVAC || this.inRFR) && this.guiTextField.func_146206_l()) {
            if (value == 28) {
                this.guiTextField.func_146195_b(false);
            } else if (this.inVAC && value == 15) {
                NetworkPlayerInfo[] list = this.field_146297_k.field_71439_g.field_71174_a.func_175106_d().toArray(new NetworkPlayerInfo[1]);
                String[] allNames = new String[list.length];
                for (int index = 0; index < list.length; ++index) {
                    allNames[index] = list[index].func_178845_a().getName();
                }
                List names = CommandBase.func_71530_a((String[])new String[]{this.guiTextField.func_146179_b()}, (String[])allNames);
                if (!names.isEmpty()) {
                    this.guiTextField.func_146180_a((String)names.get(0));
                    this.textChanged();
                }
            } else {
                this.guiTextField.func_146201_a(character, value);
                this.textChanged();
            }
        }
    }

    private void textChanged() {
        if (this.inVAC) {
            this.nameList.setSelectedElement(-1);
            UUID uuid = UUIDHelper.getCachedUUID(this.guiTextField.func_146179_b());
            if (uuid != null && this.tile.vaultAccess.contains(uuid)) {
                this.nameList.setSelectedElement(this.tile.vaultAccess.indexOf(uuid));
            }
            this.setVisibleButtons();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int buttonClicked) throws IOException {
        super.func_73864_a(mouseX, mouseY, buttonClicked);
        if (this.inVAC || this.inRFR) {
            this.guiTextField.func_146192_a(mouseX, mouseY, buttonClicked);
        }
    }

    public void func_73876_c() {
        if ((this.inVAC || this.inRFR) && this.guiTextField.func_146206_l()) {
            this.guiTextField.func_146178_a();
        }
    }

    FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    private static class Button
    extends GuiButton {
        private boolean alwaysActive;

        Button(int buttonId, int x, int y, int width, int height, String buttonText) {
            super(buttonId, x, y, width, height, buttonText);
        }

        Button alwaysActive() {
            this.alwaysActive = true;
            return this;
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && (this.field_146125_m || this.alwaysActive) && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(textureGUIVault);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 196 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 196 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(mc, mouseX, mouseY);
                int j = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    j = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
            }
        }
    }
}

