/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Values;

public class TankHelper {
    private static final Table<String, String, FluidTank> DATABASE = HashBasedTable.create();
    private static final Table<String, String, FluidTank> CLIENTCACHE = HashBasedTable.create();

    private static Table<String, String, FluidTank> getDatabase(boolean isClient) {
        return isClient ? CLIENTCACHE : DATABASE;
    }

    public static FluidTank getTank(String owner, String code, boolean isClient) {
        FluidTank tank = (FluidTank)TankHelper.getDatabase(isClient).get((Object)owner.toLowerCase(), (Object)code.toUpperCase());
        if (tank == null) {
            tank = new FluidTank(Values.tankSizeMin * 1000);
            TankHelper.getDatabase(isClient).put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)tank);
        }
        return tank;
    }

    public static void updateTank(String owner, String code, FluidStack fluidStack, boolean isClient) {
        TankHelper.getTank(owner, code, isClient).setFluid(fluidStack);
    }

    public static short getCapacityInBuckets(FluidTank tank) {
        return (short)(tank.getCapacity() / 1000);
    }

    public static void setCapacityInBuckets(FluidTank tank, short capacity) {
        tank.setCapacity(capacity * 1000);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (event.getWorld() == null || event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            NBTTagCompound fileNBT = new NBTTagCompound();
            for (Map.Entry pocket : networkMap.entrySet()) {
                FluidTank tank = (FluidTank)pocket.getValue();
                if (tank.getFluidAmount() <= 0 && tank.getCapacity() <= Values.tankSizeMin) continue;
                NBTTagCompound nbtPocket = tank.writeToNBT(new NBTTagCompound());
                nbtPocket.func_74777_a("Capacity", (short)(tank.getCapacity() / 1000));
                fileNBT.func_74782_a((String)pocket.getKey(), (NBTBase)nbtPocket);
            }
            try {
                FileOutputStream fileoutputstream = new FileOutputStream(this.getSaveFile(event.getWorld(), owner));
                CompressedStreamTools.func_74799_a((NBTTagCompound)fileNBT, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (event.getWorld() == null || event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            CLIENTCACHE.clear();
            return;
        }
        DATABASE.clear();
        List<File> fileList = this.getSaveFiles(event.getWorld());
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", ""));
            NBTTagCompound fileNBT = this.getNBTTag(file);
            for (String code : fileNBT.func_150296_c()) {
                NBTTagCompound nbtPocket = fileNBT.func_74775_l(code);
                int capacity = MathHelper.func_76125_a((int)nbtPocket.func_74765_d("Capacity"), (int)Values.tankSizeMin, (int)Values.tankSizeMax);
                FluidTank tank = new FluidTank(capacity * 1000);
                tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtPocket));
                DATABASE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)tank);
            }
        }
    }

    private List<File> getSaveFiles(World world) {
        ArrayList<File> fileList = new ArrayList<File>();
        String saveDir = EnderTanks.proxy.getSaveDir(world, Values.minecraftDir) + "/endertanks";
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(World world, String owner) {
        String saveDir = EnderTanks.proxy.getSaveDir(world, Values.minecraftDir) + "/endertanks";
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                Values.logEnderTanks.error("Could Not Read or Create File: " + file.toString(), (Throwable)error);
            }
        }
        return file;
    }

    private NBTTagCompound getNBTTag(File file) {
        NBTTagCompound nbtData = new NBTTagCompound();
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            nbtData = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nbtData;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }
}

