/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.endertanks.Values;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration config;
    private boolean firstrun;
    private String[] personalItems;
    private String[] sCapacityItems;
    private String[] lCapacityItems;
    private String[] pumpItems;

    public void setupConfig(File file) {
        this.config = new Configuration(file);
        this.config.load();
        this.firstrun = true;
        this.syncConfig();
        this.firstrun = false;
    }

    public void syncConfig() {
        this.config.addCustomCategoryComment("UPGRADE-ITEMS", "Items used to upgrade the EnderTanks");
        this.config.setCategoryRequiresWorldRestart("UPGRADE-ITEMS", false);
        this.config.setCategoryRequiresMcRestart("UPGRADE-ITEMS", false);
        this.personalItems = this.config.getStringList("Personal", "UPGRADE-ITEMS", new String[]{"OreDictionary:gemDiamond"}, "Items Listed are used to make the tanks personal\n");
        this.sCapacityItems = this.config.getStringList("SmallCapacity", "UPGRADE-ITEMS", new String[]{"minecraft:ender_pearl"}, "Items Listed upgrade storage capacity by 'SmallCapacityUpgrade'\n");
        this.lCapacityItems = this.config.getStringList("LargeCapacity", "UPGRADE-ITEMS", new String[]{"minecraft:ender_eye"}, "Items Listed upgrade storage capacity by 'LargeCapacityUpgrade'\n");
        this.pumpItems = this.config.getStringList("Pump", "UPGRADE-ITEMS", new String[]{"minecraft:piston"}, "Items Listed are used to increase the tanks internal pump\n");
        this.config.addCustomCategoryComment("UPGRADE-SETTINGS", "NOTE: Capacity numbers are in buckets");
        this.config.setCategoryRequiresWorldRestart("UPGRADE-SETTINGS", true);
        this.config.setCategoryRequiresMcRestart("UPGRADE-SETTINGS", false);
        Values.tankPumpMax = (byte)this.config.getInt("PumpUpgrades", "UPGRADE-SETTINGS", 4, 0, 8, "How many internal pump upgrades can a tank have?\n default internal pump is only 1/4 bucket, upgrades make it a bucket per upgrade.\n");
        Values.tankSizeMin = (byte)this.config.getInt("CapacityMin", "UPGRADE-SETTINGS", 32, 4, 64, "Minimum capacity an EnderTank holds.\n");
        Values.tankSizeMax = (short)this.config.getInt("CapacityMax", "UPGRADE-SETTINGS", 256, 16, 512, "Maximum capacity an EnderTank holds.\n");
        if (Values.tankSizeMax < Values.tankSizeMin) {
            Values.tankSizeMax = Values.tankSizeMin;
        }
        Values.smallCapacity = (byte)this.config.getInt("SmallCapacityUpgrade", "UPGRADE-SETTINGS", 8, 2, 16, "Capacity increased by 'SmallCapacity' Items.\n");
        Values.largeCapacity = (byte)this.config.getInt("LargeCapacityUpgrade", "UPGRADE-SETTINGS", 16, 4, 32, "Capacity increased by 'LargeCapacity' Items.\n");
        this.config.addCustomCategoryComment("COLOR-VALUES", "Color Values for Bands,\nFormat: Decimal Values (0 to 16,777,215)\nYou can use this website to get the decimal value of any color:\nhttp://www.colorhexa.com\nOr by using the Color Mixer from this website:\nhttp://www.mathsisfun.com/hexadecimal-decimal-colors.html\n");
        this.config.setCategoryRequiresWorldRestart("COLOR-VALUES", false);
        this.config.setCategoryRequiresMcRestart("COLOR-VALUES", false);
        String[] colorNames = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
        for (int scan = 0; scan < colorNames.length; scan = (int)((byte)(scan + 1))) {
            Values.colorValues[scan] = this.config.getInt(colorNames[scan], "COLOR-VALUES", Values.colorValues[scan], 0, 0xFFFFFF, "");
        }
        if (this.config.hasChanged()) {
            this.config.save();
            if (!this.firstrun) {
                this.processUpgradeItemStrings();
            }
        }
    }

    public void processUpgradeItemStrings() {
        this.process(this.personalItems, Values.itemPersonal, new ItemStack(Items.field_151045_i));
        this.process(this.sCapacityItems, Values.itemCapacitySmall, new ItemStack(Items.field_151079_bi));
        this.process(this.lCapacityItems, Values.itemCapacityLarge, new ItemStack(Items.field_151061_bv));
        this.process(this.pumpItems, Values.itemPump, new ItemStack((Block)Blocks.field_150331_J));
    }

    private void process(String[] names, ArrayList<ItemStack> list, ItemStack basic) {
        list.clear();
        for (String name : names) {
            String nameId;
            if (Strings.isNullOrEmpty((String)name)) continue;
            int meta = Short.MAX_VALUE;
            if (name.contains("@")) {
                try {
                    meta = Integer.valueOf(name.split("@")[1]);
                    name = name.substring(0, name.lastIndexOf(64));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
            String string = nameId = name.contains(":") ? name.split(":")[1] : name;
            if (modId.equalsIgnoreCase("forge") || modId.equalsIgnoreCase("oredictionary")) {
                List ores = OreDictionary.getOres((String)nameId);
                for (ItemStack ore : ores) {
                    this.addToList(ore, list);
                }
                continue;
            }
            this.addToList(this.getStack(modId, nameId, meta), list);
        }
        if (list.isEmpty()) {
            list.add(basic);
        }
    }

    private ItemStack getStack(String modId, String nameId, int meta) {
        Item item = GameRegistry.findItem((String)modId, (String)nameId);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Block block = GameRegistry.findBlock((String)modId, (String)nameId);
        if (block != null) {
            return new ItemStack(block, 1, meta);
        }
        return null;
    }

    private void addToList(ItemStack stack, ArrayList<ItemStack> list) {
        if (stack == null || list == null) {
            return;
        }
        if (list.contains(stack)) {
            return;
        }
        list.add(stack);
    }
}

