/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemMulti;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.item.EnderFluidHandlerItemStack;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class ItemEnderBucket
extends ItemMulti
implements IColored {
    public ItemEnderBucket() {
        super("ItemEnderBucket", Values.nameMapper);
        this.field_77777_bU = 1;
        this.field_77787_bX = true;
        this.func_77637_a((CreativeTabs)Values.tabEnderTanks);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (String code : StackHelper.BASECODES) {
            list.add(StackHelper.create(item, code, null));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        EnumFacing facing;
        boolean isSneaking = player.func_70093_af();
        RayTraceResult mop = this.func_77621_a(world, player, !isSneaking);
        BlockPos pos = mop != null ? mop.func_178782_a() : null;
        Boolean hitTypeBlock = mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK;
        EnumFacing enumFacing = facing = mop != null ? mop.field_178784_b : EnumFacing.func_176741_a((Random)world.field_73012_v);
        if (isSneaking && pos != null) {
            if (world.func_180495_p(pos).func_177230_c() == Values.blockEnderTank) {
                TileEntityEnderTank tankTile = (TileEntityEnderTank)world.func_175625_s(pos);
                if (tankTile.hasError()) {
                    if (!world.field_72995_K) {
                        TankInfoHelper.sendLinkError(player, 2);
                    }
                } else {
                    if (tankTile.canEdit(player)) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)StackHelper.create((Item)this, tankTile.getCode(), tankTile.getOwnerID()));
                    }
                    if (!world.field_72995_K) {
                        TankInfoHelper.sendLinkError(player, 1);
                    }
                }
            } else {
                this.placeLiquid(stack, player, world, pos, facing, hitTypeBlock);
            }
        } else if (!(pos != null && this.pickupLiquid(stack, player, world, pos, facing, hitTypeBlock) || world.field_72995_K)) {
            String[] network = new String[]{StackHelper.getOwnerID(stack), StackHelper.getCode(stack)};
            FluidTank bucketTank = TankHelper.getTank(network[0], network[1], false);
            FluidStack bucketLiquid = bucketTank.getFluid();
            TankInfoHelper.sendTankInfo(player, bucketLiquid, StackHelper.getOwnerName(stack), network[0], network[1]);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean pickupLiquid(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, boolean hitTypeBlock) {
        int getAmount;
        TileEntity hitTile = world.func_175625_s(pos);
        FluidTank bucketTank = TankHelper.getTank(StackHelper.getOwnerID(stack), StackHelper.getCode(stack), world.field_72995_K);
        FluidStack bucketLiquid = bucketTank.getFluid();
        int n = getAmount = bucketLiquid != null ? Math.min(1000, bucketTank.getCapacity() - bucketLiquid.amount) : 1000;
        if (CapabilityHelper.isFluidContainer((TileEntity)hitTile, (EnumFacing)facing)) {
            FluidStack getLiquid;
            int used;
            IFluidHandler fromHandler = CapabilityHelper.getFluidHandler((TileEntity)hitTile, (EnumFacing)facing);
            if (fromHandler != null && (used = bucketTank.fill(getLiquid = fromHandler.drain(getAmount, false), false)) > 0) {
                bucketTank.fill(fromHandler.drain(used, true), true);
                world.func_184133_a(player, pos, getLiquid.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else if (hitTile instanceof net.minecraftforge.fluids.IFluidHandler) {
            FluidStack getLiquid = ((net.minecraftforge.fluids.IFluidHandler)hitTile).drain(facing, getAmount, false);
            int used = bucketTank.fill(getLiquid, false);
            if (used > 0) {
                bucketTank.fill(((net.minecraftforge.fluids.IFluidHandler)hitTile).drain(facing, used, true), true);
                world.func_184133_a(player, pos, getLiquid.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else if (getAmount >= 1000 && hitTypeBlock) {
            if (!world.canMineBlockBody(player, pos)) {
                return false;
            }
            Block block = world.func_180495_p(pos).func_177230_c();
            FluidStack getLiquid = null;
            if (block instanceof IFluidBlock) {
                getLiquid = ((IFluidBlock)block).drain(world, pos, false);
            } else {
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                if (fluid != null) {
                    getLiquid = new FluidStack(fluid, 1000);
                }
            }
            if (getLiquid != null && (player.field_71075_bZ.field_75098_d || bucketLiquid == null || bucketLiquid.amount == 0 || getLiquid.isFluidEqual(bucketLiquid))) {
                if (!world.field_72995_K) {
                    if (block instanceof IFluidBlock) {
                        ((IFluidBlock)block).drain(world, pos, true);
                    } else {
                        Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        bucketTank.fill(getLiquid, true);
                    }
                }
                world.func_184133_a(player, pos, getLiquid.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private void placeLiquid(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, boolean hitTypeBlock) {
        int getAmount;
        TileEntity hitTile = world.func_175625_s(pos);
        FluidTank bucketTank = TankHelper.getTank(StackHelper.getOwnerID(stack), StackHelper.getCode(stack), world.field_72995_K);
        FluidStack bucketLiquid = bucketTank.getFluid();
        int n = getAmount = bucketLiquid != null ? Math.min(1000, bucketTank.getCapacity() - bucketLiquid.amount) : 1000;
        if (CapabilityHelper.isFluidContainer((TileEntity)hitTile, (EnumFacing)facing)) {
            FluidStack putLiquid;
            int used;
            IFluidHandler toHandler = CapabilityHelper.getFluidHandler((TileEntity)hitTile, (EnumFacing)facing);
            if (toHandler != null && (used = toHandler.fill(putLiquid = bucketTank.drain(getAmount, false), false)) > 0) {
                toHandler.fill(bucketTank.drain(used, true), true);
                world.func_184133_a(player, pos, putLiquid.getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return;
            }
        } else if (hitTile instanceof net.minecraftforge.fluids.IFluidHandler) {
            FluidStack putLiquid = bucketTank.drain(getAmount, false);
            int used = ((net.minecraftforge.fluids.IFluidHandler)hitTile).fill(facing, putLiquid, false);
            if (used > 0) {
                ((net.minecraftforge.fluids.IFluidHandler)hitTile).fill(facing, bucketTank.drain(getAmount, true), true);
                world.func_184133_a(player, pos, putLiquid.getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return;
            }
        } else if (getAmount >= 1000 && hitTypeBlock) {
            BlockPos sPos = pos.func_177972_a(facing);
            if (!player.func_175151_a(sPos, facing, stack)) {
                return;
            }
            IBlockState sState = world.func_180495_p(sPos);
            if (!world.func_175623_d(sPos) && sState.func_177230_c().func_149688_o(sState).func_76220_a()) {
                return;
            }
            FluidStack placeLiquid = bucketTank.drain(1000, false);
            if (placeLiquid != null) {
                if (world.field_73011_w.func_177500_n() && placeLiquid.getFluid().getBlock() == Blocks.field_150355_j) {
                    world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    for (int var11 = 0; var11 < 8; ++var11) {
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)sPos.func_177958_n() + Math.random(), (double)sPos.func_177956_o() + Math.random(), (double)sPos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                        bucketTank.drain(placeLiquid, true);
                    }
                } else {
                    ActionResult returnBucket;
                    ItemStack emptyBucket = new ItemStack(Items.field_151133_ar);
                    ItemStack phantomBucket = FluidContainerRegistry.fillFluidContainer((FluidStack)placeLiquid, (ItemStack)emptyBucket);
                    if (phantomBucket != null && ItemStack.func_77989_b((ItemStack)((ItemStack)(returnBucket = phantomBucket.func_77973_b().func_77659_a(phantomBucket, world, player, EnumHand.MAIN_HAND)).func_188398_b()), (ItemStack)emptyBucket)) {
                        world.func_184133_a(player, pos, placeLiquid.getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
                            bucketTank.drain(placeLiquid, true);
                        }
                    }
                }
            }
        }
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        UUID uuid;
        String owner;
        super.func_179215_a(nbt);
        if (nbt.func_74764_b("owner") && !(owner = nbt.func_74779_i("owner")).equals("all") && UsernameCache.containsUUID((UUID)(uuid = UUID.fromString(owner)))) {
            nbt.func_74778_a("ownername", Strings.nullToEmpty((String)UsernameCache.getLastKnownUsername((UUID)uuid)));
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return stack == null ? null : new EnderFluidHandlerItemStack(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        tooltip.add(" " + Localization.get((String)"info.endertanks.tank.code.txt") + " " + StackHelper.getCode(stack));
        String owner = StackHelper.getOwnerName(stack);
        if (!owner.equals("all")) {
            tooltip.add(" \u00a7b[-" + owner + "-]\u00a7r");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && data.stack != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    protected void addToNameMap() {
        this.add(0, "", "enderbucket_public", "public");
        this.add(1, "", "enderbucket_private", "private");
    }
}

