/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public abstract class WorldStorage
implements INBTProvider {
    private static String KEY = "WorldStorageData";
    protected final ModBase mod;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);

    public WorldStorage(ModBase mod) {
        this.mod = mod;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.readGeneratedFieldsFromNBT(tag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.writeGeneratedFieldsToNBT(tag);
    }

    public abstract void reset();

    public void onAboutToStartEvent(FMLServerAboutToStartEvent event) {
        this.reset();
    }

    public void onStartedEvent(FMLServerStartedEvent event) {
        this.loadData();
        this.afterLoad();
    }

    public void onStoppingEvent(FMLServerStoppingEvent event) {
        this.beforeSave();
        this.saveData();
    }

    protected abstract String getDataId();

    private NBTDataHolder initDataHolder(boolean loading) {
        NBTTagCompound tempTag;
        String dataId = this.mod.getModId() + "_" + this.getDataId();
        NBTDataHolder data = (NBTDataHolder)FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].func_72943_a(NBTDataHolder.class, dataId);
        if (data == null) {
            data = new NBTDataHolder(dataId);
            FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].func_72823_a(dataId, (WorldSavedData)data);
        } else if (loading && (tempTag = data.getTempTagAndReset()) != null) {
            this.readFromNBT(tempTag);
        }
        data.setParentStorage(this);
        return data;
    }

    private synchronized void loadData() {
        this.initDataHolder(true);
    }

    private synchronized void saveData() {
        this.initDataHolder(false);
    }

    public void afterLoad() {
    }

    public void beforeSave() {
    }

    @Override
    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }

    public static class NBTDataHolder
    extends WorldSavedData {
        private WorldStorage parentStorage = null;
        private NBTTagCompound tempTag = null;

        public NBTDataHolder(String key) {
            super(key);
        }

        public void func_76184_a(NBTTagCompound tag) {
            if (this.parentStorage == null) {
                this.tempTag = tag.func_74775_l(KEY);
            } else {
                this.parentStorage.readFromNBT(tag.func_74775_l(KEY));
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound tag) {
            NBTTagCompound dataTag = new NBTTagCompound();
            this.parentStorage.writeToNBT(dataTag);
            tag.func_74782_a(KEY, (NBTBase)dataTag);
            return tag;
        }

        public boolean func_76188_b() {
            return true;
        }

        public void setParentStorage(WorldStorage parentStorage) {
            this.parentStorage = parentStorage;
        }

        public NBTTagCompound getTempTagAndReset() {
            NBTTagCompound tempTag = this.tempTag;
            this.tempTag = null;
            return tempTag;
        }
    }
}

