/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;

public class CapabilityConstructorRegistry {
    private Multimap<Class<? extends TileEntity>, ICapabilityConstructor<?, ? extends TileEntity, ? extends TileEntity>> capabilityConstructorsTile = HashMultimap.create();
    private Multimap<Class<? extends Entity>, ICapabilityConstructor<?, ? extends Entity, ? extends Entity>> capabilityConstructorsEntity = HashMultimap.create();
    private Multimap<Class<? extends Item>, ICapabilityConstructor<?, ? extends Item, ? extends ItemStack>> capabilityConstructorsItem = HashMultimap.create();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsTileSuper = Sets.newHashSet();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsEntitySuper = Sets.newHashSet();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsItemSuper = Sets.newHashSet();
    protected final ModBase mod;
    protected boolean baked = false;

    public CapabilityConstructorRegistry(ModBase mod) {
        this.mod = mod;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected ModBase getMod() {
        return this.mod;
    }

    protected void checkNotBaked() {
        if (this.baked) {
            throw new IllegalStateException("Please register capabilities before pre-init.");
        }
    }

    public <T extends TileEntity> void registerTile(Class<T> clazz, ICapabilityConstructor<?, T, T> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsTile.put(clazz, constructor);
    }

    public <T extends Entity> void registerEntity(Class<T> clazz, ICapabilityConstructor<?, T, T> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsEntity.put(clazz, constructor);
    }

    public <T extends Item> void registerItem(Class<T> clazz, ICapabilityConstructor<?, T, ItemStack> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsItem.put(clazz, constructor);
    }

    public <K, V> void registerInheritableTile(Class<K> clazz, ICapabilityConstructor<?, V, V> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsTileSuper.add(Pair.of(clazz, constructor));
    }

    public <K, V> void registerInheritableEntity(Class<K> clazz, ICapabilityConstructor<?, V, V> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsEntitySuper.add(Pair.of(clazz, constructor));
    }

    public <T> void registerInheritableItem(Class<T> clazz, ICapabilityConstructor<?, ?, ? extends ItemStack> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsItemSuper.add(Pair.of(clazz, constructor));
    }

    protected <K, KE, H, HE> ICapabilityProvider createProvider(KE hostType, HE host, ICapabilityConstructor<?, K, H> capabilityConstructor) {
        return capabilityConstructor.createProvider(hostType, host);
    }

    protected <T> void onLoad(Multimap<Class<? extends T>, ICapabilityConstructor<?, ? extends T, ? extends T>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors, T object, AttachCapabilitiesEvent event) {
        this.onLoad(allConstructors, allInheritableConstructors, object, object, event);
    }

    protected <K, V> void onLoad(Multimap<Class<? extends K>, ICapabilityConstructor<?, ? extends K, ? extends V>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors, K keyObject, V valueObject, AttachCapabilitiesEvent event) {
        boolean initialized;
        boolean bl = initialized = this.baked || Helpers.isMinecraftInitialized();
        if (!this.baked && Helpers.isMinecraftInitialized()) {
            this.bake();
        }
        Collection constructors = allConstructors.get(keyObject.getClass());
        for (ICapabilityConstructor iCapabilityConstructor : constructors) {
            if (!initialized && iCapabilityConstructor.getCapability() == null) continue;
            this.addLoadedCapabilityProvider(event, keyObject, valueObject, iCapabilityConstructor);
        }
        for (Pair pair : allInheritableConstructors) {
            if (!initialized && ((ICapabilityConstructor)pair.getRight()).getCapability() == null || !((Class)pair.getLeft()).isInstance(keyObject)) continue;
            this.addLoadedCapabilityProvider(event, keyObject, valueObject, (ICapabilityConstructor)pair.getRight());
        }
    }

    protected <K, V> void addLoadedCapabilityProvider(AttachCapabilitiesEvent event, K keyObject, V valueObject, ICapabilityConstructor<?, ?, ?> constructor) {
        ICapabilityProvider provider = this.createProvider(keyObject, valueObject, constructor);
        if (provider != null) {
            ResourceLocation id = new ResourceLocation(this.getMod().getModId(), constructor.getCapability().getName());
            if (!event.getCapabilities().containsKey(id)) {
                event.addCapability(id, provider);
            } else {
                this.getMod().getLoggerHelper().log(Level.DEBUG, "Duplicate capability registration of " + id + " in " + keyObject);
            }
        }
    }

    @SubscribeEvent
    public void onTileLoad(AttachCapabilitiesEvent.TileEntity event) {
        this.onLoad(this.capabilityConstructorsTile, this.capabilityConstructorsTileSuper, event.getTileEntity(), (AttachCapabilitiesEvent)event);
    }

    @SubscribeEvent
    public void onEntityLoad(AttachCapabilitiesEvent.Entity event) {
        this.onLoad(this.capabilityConstructorsEntity, this.capabilityConstructorsEntitySuper, event.getEntity(), (AttachCapabilitiesEvent)event);
    }

    @SubscribeEvent
    public void onItemStackLoad(AttachCapabilitiesEvent.Item event) {
        this.onLoad(this.capabilityConstructorsItem, this.capabilityConstructorsItemSuper, event.getItem(), event.getItemStack(), (AttachCapabilitiesEvent)event);
    }

    protected <K, V> void removeNullCapabilities(Multimap<Class<? extends K>, ICapabilityConstructor<?, ? extends K, ? extends V>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors) {
        HashMultimap toRemoveMap = HashMultimap.create();
        for (Class key : allConstructors.keys()) {
            Collection constructors = allConstructors.get((Object)key);
            for (ICapabilityConstructor constructor : constructors) {
                if (constructor.getCapability() != null) continue;
                toRemoveMap.put((Object)key, (Object)constructor);
            }
        }
        for (Map.Entry entry : toRemoveMap.entries()) {
            allConstructors.remove(entry.getKey(), entry.getValue());
        }
        ArrayList toRemoveInheritableList = Lists.newArrayList();
        for (Pair<Class<?>, ICapabilityConstructor<?, ?, ?>> constructorEntry : allInheritableConstructors) {
            if (((ICapabilityConstructor)constructorEntry.getRight()).getCapability() != null) continue;
            toRemoveInheritableList.add(constructorEntry);
        }
        for (Pair toRemove : toRemoveInheritableList) {
            allInheritableConstructors.remove(toRemove);
        }
    }

    public void bake() {
        this.baked = true;
        this.removeNullCapabilities(this.capabilityConstructorsTile, this.capabilityConstructorsTileSuper);
        this.removeNullCapabilities(this.capabilityConstructorsEntity, this.capabilityConstructorsEntitySuper);
        this.removeNullCapabilities(this.capabilityConstructorsItem, this.capabilityConstructorsItemSuper);
        this.capabilityConstructorsTile = ImmutableMultimap.copyOf(this.capabilityConstructorsTile);
        this.capabilityConstructorsEntity = ImmutableMultimap.copyOf(this.capabilityConstructorsEntity);
        this.capabilityConstructorsItem = ImmutableMultimap.copyOf(this.capabilityConstructorsItem);
        this.capabilityConstructorsTileSuper = ImmutableList.copyOf(this.capabilityConstructorsTileSuper);
        this.capabilityConstructorsEntitySuper = ImmutableList.copyOf(this.capabilityConstructorsEntitySuper);
        this.capabilityConstructorsItemSuper = ImmutableList.copyOf(this.capabilityConstructorsItemSuper);
    }
}

