/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionServer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonClickAcceptorServer;
import org.cyclops.cyclopscore.inventory.slot.SlotArmor;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.packet.ValueNotifyPacket;

public abstract class InventoryContainer
extends Container
implements IButtonClickAcceptorServer<InventoryContainer>,
IValueNotifier,
IValueNotifiable {
    private static final EntityEquipmentSlot[] EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    protected static final int ITEMBOX = 18;
    private final Map<Integer, IButtonActionServer> buttonActions = Maps.newHashMap();
    private final Map<Integer, NBTTagCompound> values = Maps.newHashMap();
    private int nextValueId = 0;
    private IValueNotifiable guiValueListener = null;
    private IInventory playerIInventory;
    protected final EntityPlayer player;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public InventoryContainer(InventoryPlayer inventory) {
        this.playerIInventory = inventory;
        this.player = inventory.field_70458_d;
    }

    public void setGuiValueListener(IValueNotifiable listener) {
        this.guiValueListener = listener;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (!MinecraftHelpers.isClientSide()) {
            this.initializeValues();
        }
    }

    protected void initializeValues() {
    }

    protected Slot createNewSlot(IInventory inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y);
    }

    protected Slot func_75146_a(Slot slot) {
        slot.field_75223_e += this.offsetX;
        slot.field_75221_f += this.offsetY;
        return super.func_75146_a(slot);
    }

    protected void addInventory(IInventory inventory, int indexOffset, int offsetX, int offsetY, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.func_75146_a(this.createNewSlot(inventory, x + y * cols + indexOffset, offsetX + x * 18, offsetY + y * 18));
            }
        }
    }

    protected void addPlayerInventory(InventoryPlayer inventory, int offsetX, int offsetY) {
        int rows = 3;
        int cols = 9;
        this.addInventory((IInventory)inventory, cols, offsetX, offsetY, rows, cols);
        this.addInventory((IInventory)inventory, 0, offsetX, offsetY += 58, 1, cols);
    }

    protected void addPlayerArmorInventory(InventoryPlayer inventory, int offsetX, int offsetY) {
        for (int k = 0; k < 4; ++k) {
            EntityEquipmentSlot equipmentSlot = EQUIPMENT_SLOTS[k];
            this.func_75146_a(new SlotArmor((IInventory)inventory, 36 + (3 - k), offsetX, offsetY + k * 18, inventory.field_70458_d, equipmentSlot));
        }
    }

    protected abstract int getSizeInventory();

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        return slotStart;
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        return slotRange;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        int slots = this.getSizeInventory();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slotID < slots ? !this.func_75135_a(stackInSlot, this.getSlotStart(slotID, slots, true), this.getSlotRange(slotID, this.field_75151_b.size(), true), true) : !this.func_75135_a(stackInSlot, this.getSlotStart(slotID, 0, false), this.getSlotRange(slotID, slots, false), false)) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotRange, boolean reverse) {
        ItemStack existingStack;
        Slot slot;
        boolean successful = false;
        int slotIndex = slotStart;
        int maxStack = stack.func_77976_d();
        if (reverse) {
            slotIndex = slotRange - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                int maxSlotSize = Math.min(slot.func_75219_a(), maxStack);
                existingStack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && existingStack != null && existingStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77952_i() == existingStack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.field_77994_a + stack.field_77994_a;
                    if (existingSize <= maxSlotSize) {
                        stack.field_77994_a = 0;
                        existingStack.field_77994_a = existingSize;
                        slot.func_75218_e();
                        successful = true;
                    } else if (existingStack.field_77994_a < maxSlotSize) {
                        stack.field_77994_a -= maxSlotSize - existingStack.field_77994_a;
                        existingStack.field_77994_a = maxSlotSize;
                        slot.func_75218_e();
                        successful = true;
                    }
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.field_77994_a > 0) {
            slotIndex = reverse ? slotRange - 1 : slotStart;
            while (stack.field_77994_a > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                existingStack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && existingStack == null) {
                    int placedAmount = Math.min(stack.field_77994_a, slot.func_75219_a());
                    ItemStack toPut = stack.func_77946_l();
                    toPut.field_77994_a = placedAmount;
                    slot.func_75215_d(toPut);
                    slot.func_75218_e();
                    stack.field_77994_a -= placedAmount;
                    successful = true;
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return successful;
    }

    public IInventory getPlayerIInventory() {
        return this.playerIInventory;
    }

    public ItemStack func_184996_a(int slotId, int arg, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof SlotExtended && ((SlotExtended)slot).isPhantom()) {
            return this.slotClickPhantom(slot, arg, clickType, player);
        }
        return super.func_184996_a(slotId, arg, clickType, player);
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickType, EntityPlayer player) {
        ItemStack stack = null;
        if (mouseButton == 2) {
            if (((SlotExtended)slot).isAdjustable()) {
                slot.func_75215_d(null);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.field_71071_by;
            slot.func_75218_e();
            ItemStack stackSlot = slot.func_75211_c();
            ItemStack stackHeld = playerInv.func_70445_o();
            if (stackSlot != null) {
                stack = stackSlot.func_77946_l();
            }
            if (stackSlot == null) {
                if (stackHeld != null && slot.func_75214_a(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            } else if (stackHeld == null) {
                this.adjustPhantomSlot(slot, mouseButton, clickType);
                slot.func_82870_a(player, playerInv.func_70445_o());
            } else if (slot.func_75214_a(stackHeld)) {
                if (ItemStack.func_77989_b((ItemStack)stackSlot, (ItemStack)stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (clickType == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.field_77994_a + 1) / 2 : stackSlot.field_77994_a * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.field_77994_a - 1 : stackSlot.field_77994_a + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.field_77994_a = stackSize;
        if (stackSlot.field_77994_a <= 0) {
            slot.func_75215_d(null);
        }
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.field_77994_a : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.field_77994_a = stackSize;
        slot.func_75215_d(phantomStack);
    }

    @Override
    public void putButtonAction(int buttonId, IButtonActionServer<InventoryContainer> action) {
        this.buttonActions.put(buttonId, action);
    }

    @Override
    public boolean requiresAction(int buttonId) {
        return this.buttonActions.containsKey(buttonId);
    }

    @Override
    public void onButtonClick(int buttonId) {
        IButtonActionServer action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.onAction(buttonId, this);
        }
    }

    protected int getNextValueId() {
        return this.nextValueId++;
    }

    @Override
    public void setValue(int valueId, NBTTagCompound value) {
        if (!this.values.containsKey(valueId) || !this.values.get(valueId).equals((Object)value)) {
            if (!MinecraftHelpers.isClientSide()) {
                CyclopsCore._instance.getPacketHandler().sendToPlayer(new ValueNotifyPacket(valueId, value), (EntityPlayerMP)this.player);
            } else {
                CyclopsCore._instance.getPacketHandler().sendToServer(new ValueNotifyPacket(valueId, value));
            }
            this.values.put(valueId, value);
        }
    }

    @Override
    public NBTTagCompound getValue(int valueId) {
        return this.values.get(valueId);
    }

    @Override
    public void onUpdate(int valueId, NBTTagCompound value) {
        this.values.put(valueId, value);
        if (this.guiValueListener != null) {
            this.guiValueListener.onUpdate(valueId, value);
        }
    }
}

