/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.InfoSectionTagIndex;
import org.cyclops.cyclopscore.infobook.pageelement.CraftingRecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.FurnaceRecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.ImageAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.xml.ConfigRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeConditionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfoBookParser {
    private static final Map<String, IInfoSectionFactory> SECTION_FACTORIES = Maps.newHashMap();
    private static final Map<String, IAppendixFactory> APPENDIX_FACTORIES = Maps.newHashMap();
    private static final Set<String> IGNORED_APPENDIX_FACTORIES = Sets.newHashSet();
    private static final Map<String, IAppendixItemFactory> APPENDIX_LIST_FACTORIES = Maps.newHashMap();
    public static Map<String, Pair<InfoSection, Integer>> configLinks;

    public static void registerFactory(String name, IInfoSectionFactory factory) {
        if (SECTION_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("A section factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerIgnoredFactory(String name) {
        IGNORED_APPENDIX_FACTORIES.add(name);
    }

    public static void registerFactory(String name, IAppendixFactory factory) {
        if (APPENDIX_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerFactory(String name, IAppendixItemFactory factory) {
        if (APPENDIX_LIST_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix item factory with name %s was registered while another one already existed!", name));
        }
    }

    public static int getIndex(Element node) {
        int index = 0;
        if (!node.getAttribute("index").isEmpty()) {
            index = Integer.parseInt(node.getAttribute("index"));
        }
        return index;
    }

    public static ItemStack createStack(Element node, RecipeHandler recipeHandler) throws InvalidAppendixException {
        int meta = Short.MAX_VALUE;
        if (!node.getAttribute("meta").isEmpty()) {
            meta = Integer.parseInt(node.getAttribute("meta"));
        }
        if ("true".equals(node.getAttribute("predefined"))) {
            ItemStack itemStack = recipeHandler.getPredefinedItem(node.getTextContent());
            if (itemStack == null) {
                throw new InvalidAppendixException("Could not find predefined item " + node.getTextContent());
            }
            return itemStack;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(node.getTextContent()));
        if (item == null) {
            throw new InvalidAppendixException("Invalid item " + node.getTextContent());
        }
        return new ItemStack(item, 1, meta);
    }

    public static InfoSection initializeInfoBook(IInfoBook infoBook, String path) {
        try {
            InputStream is = InfoBookParser.class.getResourceAsStream(path);
            StreamSource stream = new StreamSource(is);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream.getInputStream());
            InfoSection root = InfoBookParser.buildSection(infoBook, null, 0, doc.getDocumentElement());
            root.registerSection(new InfoSectionTagIndex(infoBook, root));
            return root;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            throw new InfoBookException("Info Book XML is invalid.");
        }
    }

    protected static InfoSection buildSection(IInfoBook infoBook, InfoSection parent, int childIndex, Element sectionElement) {
        ModBase mod = infoBook.getMod();
        NodeList sections = sectionElement.getElementsByTagName("section");
        NodeList tags = sectionElement.getElementsByTagName("tag");
        NodeList paragraphs = sectionElement.getElementsByTagName("paragraph");
        NodeList appendixes = sectionElement.getElementsByTagName("appendix");
        NodeList appendixLists = sectionElement.getElementsByTagName("appendixList");
        ArrayList paragraphList = Lists.newArrayListWithCapacity((int)paragraphs.getLength());
        ArrayList appendixList = Lists.newArrayListWithCapacity((int)appendixes.getLength());
        ArrayList tagList = Lists.newArrayListWithCapacity((int)tags.getLength());
        InfoSection section = InfoBookParser.createSection(infoBook, parent, childIndex, sectionElement.getAttribute("type"), sectionElement.getAttribute("name"), paragraphList, appendixList, tagList);
        if (sections.getLength() > 0) {
            int subChildIndex = 0;
            for (int i = 0; i < sections.getLength(); ++i) {
                InfoSection subsubsection;
                Element subsection = (Element)sections.item(i);
                if (subsection.getParentNode() != sectionElement || (subsubsection = InfoBookParser.buildSection(infoBook, section, subChildIndex, subsection)) == null) continue;
                section.registerSection(subsubsection);
                ++subChildIndex;
            }
        } else {
            int j;
            for (j = 0; j < tags.getLength(); ++j) {
                IRecipeConditionHandler conditionHandler;
                Element tag = (Element)tags.item(j);
                String tagString = tag.getTextContent();
                String type = "config";
                if (tag.hasAttribute("type")) {
                    type = tag.getAttribute("type");
                }
                if (!(conditionHandler = mod.getRecipeHandler().getRecipeConditionHandlers().get(type)).isSatisfied(mod.getRecipeHandler(), tag.getTextContent())) {
                    return null;
                }
                if (!(conditionHandler instanceof ConfigRecipeConditionHandler)) continue;
                tagList.add(tagString);
            }
            for (j = 0; j < paragraphs.getLength(); ++j) {
                Element paragraph = (Element)paragraphs.item(j);
                paragraphList.add(paragraph.getTextContent());
            }
            for (j = 0; j < appendixes.getLength(); ++j) {
                try {
                    Element appendix = (Element)appendixes.item(j);
                    appendixList.add(InfoBookParser.createAppendix(infoBook, appendix.getAttribute("type"), appendix));
                    continue;
                }
                catch (InvalidAppendixException e) {
                    infoBook.getMod().log(Level.WARN, e.getMessage());
                }
            }
            for (j = 0; j < appendixLists.getLength(); ++j) {
                Element appendixListNode = (Element)appendixLists.item(j);
                String type = appendixListNode.getAttribute("type");
                Collection itemStacks = mod.getRecipeHandler().getTaggedOutput().get((Object)appendixListNode.getTextContent());
                for (ItemStack itemStack : itemStacks) {
                    try {
                        appendixList.add(InfoBookParser.createAppendix(infoBook, type, itemStack));
                    }
                    catch (InvalidAppendixException e) {
                        infoBook.getMod().log(Level.WARN, e.getMessage());
                    }
                }
            }
        }
        return section;
    }

    protected static InfoSection createSection(IInfoBook infoBook, InfoSection parent, int childIndex, String type, String unlocalizedName, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
        IInfoSectionFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = SECTION_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No section of type '" + type + "' was found.");
        }
        return factory.create(infoBook, parent, childIndex, unlocalizedName, paragraphs, appendixes, tagList);
    }

    protected static SectionAppendix createAppendix(IInfoBook infoBook, String type, Element node) throws InvalidAppendixException {
        IAppendixFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_FACTORIES.get(type)) == null) {
            if (IGNORED_APPENDIX_FACTORIES.contains(type)) {
                throw new InvalidAppendixException("Ignore appendix of type '" + type + "'.");
            }
            throw new InfoBookException("No appendix of type '" + type + "' was found.");
        }
        return factory.create(infoBook, node);
    }

    protected static SectionAppendix createAppendix(IInfoBook infoBook, String type, ItemStack itemStack) throws InvalidAppendixException {
        IAppendixItemFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_LIST_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No appendix list of type '" + type + "' was found.");
        }
        return factory.create(infoBook, itemStack);
    }

    static {
        InfoBookParser.registerFactory("", new IInfoSectionFactory(){

            @Override
            public InfoSection create(IInfoBook infoBook, InfoSection parent, int childIndex, String unlocalizedName, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
                return new InfoSection(infoBook, parent, childIndex, unlocalizedName, paragraphs, appendixes, tagList);
            }
        });
        InfoBookParser.registerFactory("image", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                return new ImageAppendix(infoBook, new ResourceLocation(node.getTextContent()), Integer.parseInt(node.getAttribute("width")), Integer.parseInt(node.getAttribute("height")));
            }
        });
        InfoBookParser.registerFactory("craftingRecipe", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                try {
                    return new CraftingRecipeAppendix(infoBook, CraftingHelpers.findCraftingRecipe(InfoBookParser.createStack(node, infoBook.getMod().getRecipeHandler()), InfoBookParser.getIndex(node)));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
        InfoBookParser.registerFactory("furnaceRecipe", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                try {
                    return new FurnaceRecipeAppendix(infoBook, CraftingHelpers.findFurnaceRecipe(InfoBookParser.createStack(node, infoBook.getMod().getRecipeHandler()), InfoBookParser.getIndex(node)));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
        InfoBookParser.registerFactory("craftingRecipe", new IAppendixItemFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, ItemStack itemStack) throws InvalidAppendixException {
                try {
                    return new CraftingRecipeAppendix(infoBook, CraftingHelpers.findCraftingRecipe(itemStack, 0));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
        InfoBookParser.registerFactory("furnaceRecipe", new IAppendixItemFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, ItemStack itemStack) throws InvalidAppendixException {
                try {
                    return new FurnaceRecipeAppendix(infoBook, CraftingHelpers.findFurnaceRecipe(itemStack, 0));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
    }

    public static class InvalidAppendixException
    extends Exception {
        public InvalidAppendixException(String message) {
            super(message);
        }
    }

    public static class InfoBookException
    extends RuntimeException {
        public InfoBookException(String message) {
            super(message);
        }
    }

    public static interface IAppendixItemFactory {
        public SectionAppendix create(IInfoBook var1, ItemStack var2) throws InvalidAppendixException;
    }

    public static interface IAppendixFactory {
        public SectionAppendix create(IInfoBook var1, Element var2) throws InvalidAppendixException;
    }

    public static interface IInfoSectionFactory {
        public InfoSection create(IInfoBook var1, InfoSection var2, int var3, String var4, ArrayList<String> var5, List<SectionAppendix> var6, ArrayList<String> var7);
    }
}

