/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class FluidHelpers {
    public static int getAmount(@Nullable FluidStack fluidStack) {
        return fluidStack != null ? fluidStack.amount : 0;
    }

    public static FluidStack copy(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        return new FluidStack(fluidStack.getFluid(), fluidStack.amount, fluidStack.tag);
    }

    public static boolean canCompletelyFill(IFluidHandler source, IFluidHandler destination) {
        FluidStack drained = source.drain(Integer.MAX_VALUE, false);
        return drained != null && destination.fill(drained, false) == drained.amount;
    }

    public static FluidStack getFluid(@Nullable IFluidHandler fluidHandler) {
        return fluidHandler != null ? fluidHandler.drain(Integer.MAX_VALUE, false) : null;
    }

    public static boolean hasFluid(@Nullable IFluidHandler fluidHandler) {
        return FluidHelpers.getFluid(fluidHandler) != null;
    }

    public static int getCapacity(@Nullable IFluidHandler fluidHandler) {
        IFluidTankProperties[] arr$;
        int len$;
        int i$;
        if (fluidHandler != null && (i$ = 0) < (len$ = (arr$ = fluidHandler.getTankProperties()).length)) {
            IFluidTankProperties properties = arr$[i$];
            return properties.getCapacity();
        }
        return 0;
    }
}

