/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import java.io.IOException;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class ScrollingGuiContainer
extends GuiContainerExtended {
    private static final ResourceLocation SCROLLBUTTON = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int SCROLL_BUTTON_HEIGHT = 15;
    private static final int SCROLL_BUTTON_WIDTH = 12;
    private static final int SEARCH_WIDTH = 89;
    protected float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private GuiTextField searchField = null;

    public ScrollingGuiContainer(ScrollingInventoryContainer container) {
        super(container);
        this.field_146291_p = true;
    }

    protected ScrollingInventoryContainer getScrollingInventoryContainer() {
        return (ScrollingInventoryContainer)this.field_147002_h;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        boolean resetFilter = false;
        if (this.isSearchEnabled()) {
            int searchWidth = this.getSearchWidth();
            int searchX = this.getSearchX();
            int searchY = this.getSearchY();
            if (this.searchField == null) {
                resetFilter = true;
                this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + searchX, this.field_147009_r + searchY, searchWidth, this.field_146289_q.field_78288_b);
                this.searchField.func_146203_f(64);
                this.searchField.func_146203_f(15);
                this.searchField.func_146185_a(false);
                this.searchField.func_146189_e(true);
                this.searchField.func_146193_g(0xFFFFFF);
                this.searchField.func_146205_d(true);
                this.searchField.func_146180_a("");
                this.searchField.field_146218_h = searchWidth;
                this.searchField.field_146209_f = this.field_147003_i + (searchX + searchWidth) - this.searchField.field_146218_h;
            } else {
                this.searchField.field_146218_h = searchWidth;
                this.searchField.field_146209_f = this.field_147003_i + (searchX + searchWidth) - this.searchField.field_146218_h;
                this.searchField.field_146210_g = this.field_147009_r + searchY;
            }
        }
        if (resetFilter) {
            this.getScrollingInventoryContainer().updateFilter("");
        }
        this.getScrollingInventoryContainer().scrollTo(this.currentScroll);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.isSearchEnabled() && !this.func_146983_a(keyCode) && this.searchField.func_146201_a(typedChar, keyCode)) {
            this.updateSearch(this.searchField.func_146179_b());
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected int getScrollStep() {
        return this.getScrollingInventoryContainer().getFilteredItemCount() / this.getScrollingInventoryContainer().getColumns() - this.getScrollingInventoryContainer().getPageSize() + 1;
    }

    protected void scrollRelative(int step) {
        this.currentScroll = (float)((double)this.currentScroll - (double)step / (double)this.getScrollStep());
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        this.getScrollingInventoryContainer().scrollTo(this.currentScroll);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.scrollRelative(i);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isSearchEnabled()) {
            this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean flag = Mouse.isButtonDown((int)0);
        int k = this.field_147003_i;
        int l = this.field_147009_r;
        int i1 = k + this.getScrollX();
        int j1 = l + this.getScrollY();
        int k1 = i1 + 14;
        int l1 = j1 + this.getScrollHeight();
        if (!this.wasClicking && flag && mouseX >= i1 && mouseY >= j1 && mouseX < k1 && mouseY < l1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - j1) - 7.5f) / ((float)(l1 - j1) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.getScrollingInventoryContainer().scrollTo(this.currentScroll);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.isSearchEnabled()) {
            this.searchField.func_146194_f();
        }
        int scrollX = this.field_147003_i + this.getScrollX();
        int scrollMinY = this.field_147009_r + this.getScrollY();
        int scrollMaxY = scrollMinY + this.getScrollHeight();
        this.field_146297_k.func_110434_K().func_110577_a(SCROLLBUTTON);
        this.func_73729_b(scrollX, scrollMinY + (int)((float)(scrollMaxY - scrollMinY - 15 - 2) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    protected void updateSearch(String searchString) {
        this.currentScroll = 0.0f;
        this.getScrollingInventoryContainer().updateFilter(searchString);
    }

    protected boolean needsScrollBars() {
        return this.getScrollingInventoryContainer().getFilteredItemCount() > this.getScrollingInventoryContainer().getPageSize();
    }

    public GuiTextField getSearchField() {
        return this.searchField;
    }

    protected int getScrollX() {
        return 175;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 112;
    }

    protected boolean isSearchEnabled() {
        return true;
    }

    protected int getSearchX() {
        return 82;
    }

    protected int getSearchY() {
        return 6;
    }

    protected int getSearchWidth() {
        return 89;
    }
}

