/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.util;

import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.manager.CastingRecipeManager;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class FoundryMiscUtils {
    public static int divCeil(int a, int b) {
        return a / b + (a % b == 0 ? 0 : 1);
    }

    public static String getItemOreDictionaryName(ItemStack stack) {
        for (String name : OreDictionary.getOreNames()) {
            List ores = OreDictionary.getOres((String)name);
            for (ItemStack i : ores) {
                if (!i.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)i, (ItemStack)stack)) continue;
                return name;
            }
        }
        return null;
    }

    public static ItemStack getModItemFromOreDictionary(String modid, String orename) {
        return FoundryMiscUtils.getModItemFromOreDictionary(modid, orename, 1);
    }

    public static ItemStack getModItemFromOreDictionary(String modid, String orename, int amount) {
        modid = modid.toLowerCase();
        for (ItemStack is : OreDictionary.getOres((String)orename)) {
            if (!is.func_77973_b().getRegistryName().func_110624_b().equals(modid)) continue;
            is = is.func_77946_l();
            is.field_77994_a = amount;
            return is;
        }
        return null;
    }

    public static void registerInOreDictionary(String name, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!FoundryUtils.isItemInOreDictionary(name, stack)) {
            OreDictionary.registerOre((String)name, (ItemStack)stack);
        }
    }

    public static FluidStack drainFluidFromWorld(World world, BlockPos pos, boolean do_drain) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IFluidBlock) {
            IFluidBlock fluid_block = (IFluidBlock)state;
            if (!fluid_block.canDrain(world, pos)) {
                return null;
            }
            return fluid_block.drain(world, pos, do_drain);
        }
        if (state.func_185904_a() == Material.field_151586_h && Integer.valueOf(0).equals(state.func_177229_b((IProperty)BlockLiquid.field_176367_b))) {
            if (do_drain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (state.func_185904_a() == Material.field_151587_i && Integer.valueOf(0).equals(state.func_177229_b((IProperty)BlockLiquid.field_176367_b))) {
            if (do_drain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void localizeTooltip(String key, List<String> tooltip) {
        for (String str : new TextComponentTranslation(key, new Object[0]).func_150260_c().split("//")) {
            tooltip.add(TextFormatting.GRAY + str);
        }
    }

    public static void registerCasting(ItemStack item, Fluid liquid_metal, int ingots, ItemMold.SubItem mold_meta, ItemStack extra) {
        FoundryMiscUtils.registerCasting(item, new FluidStack(liquid_metal, 108 * ingots), mold_meta, extra);
    }

    public static void registerCasting(ItemStack item, FluidStack fluid, ItemMold.SubItem mold_meta, ItemStack extra) {
        if (item != null) {
            ItemStack mold = FoundryItems.mold(mold_meta);
            if (CastingRecipeManager.instance.findRecipe(new FluidStack(fluid.getFluid(), 6000), mold, extra) == null) {
                ItemStackMatcher mextra = null;
                if (extra != null) {
                    mextra = new ItemStackMatcher(extra);
                }
                CastingRecipeManager.instance.addRecipe(new ItemStackMatcher(item), fluid, mold, mextra);
            }
        }
    }
}

