/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity.renderer;

import exter.foundry.tileentity.TileEntityRefractoryTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TankRenderer
extends TileEntitySpecialRenderer<TileEntityRefractoryTank> {
    private void drawQuad(EnumFacing facing, TextureAtlasSprite texture, double x1, double y1, double x2, double y2, double z, int color, int light) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        double u1 = texture.func_94214_a(x1);
        double v1 = texture.func_94207_b(y1);
        double u2 = texture.func_94214_a(x2);
        double v2 = texture.func_94207_b(y2);
        int l1 = light >> 16 & 0xFFFF;
        int l2 = light & 0xFFFF;
        x1 /= 16.0;
        y1 /= 16.0;
        x2 /= 16.0;
        y2 /= 16.0;
        z /= 16.0;
        VertexBuffer tessellator = Tessellator.func_178181_a().func_178180_c();
        tessellator.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        switch (facing) {
            case EAST: {
                tessellator.func_181662_b(z, y2, x2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y2, x1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y1, x1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y1, x2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                break;
            }
            case WEST: {
                tessellator.func_181662_b(z, y2, x1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y2, x2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y1, x2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y1, x1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                break;
            }
            case SOUTH: {
                tessellator.func_181662_b(x2, y2, z).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, y2, z).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, y1, z).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, y1, z).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                break;
            }
            case NORTH: {
                tessellator.func_181662_b(x1, y2, z).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, y2, z).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, y1, z).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, y1, z).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                break;
            }
            case UP: {
                tessellator.func_181662_b(x1, z, y2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, z, y2).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, z, y1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, z, y1).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                break;
            }
            case DOWN: {
                tessellator.func_181662_b(x2, z, y2).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, z, y2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, z, y1).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, z, y1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public void renderTileEntityAt(TileEntityRefractoryTank te, double x, double y, double z, float partialTicks, int destroyStage) {
        FluidStack fluid = te.getTank(0).getFluid();
        if (fluid != null && fluid.amount > 50) {
            GL11.glPushMatrix();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179118_c();
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179117_G();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
            double fluid_z = (double)fluid.amount / (double)te.getTank(0).getCapacity() * 11.99 + 2.0;
            int color = fluid.getFluid().getColor();
            int light = te.func_145831_w().func_175626_b(te.func_174877_v(), fluid.getFluid().getLuminosity());
            this.drawQuad(EnumFacing.UP, texture, 0.995, 0.995, 15.005, 15.005, fluid_z, color, light);
            this.drawQuad(EnumFacing.NORTH, texture, 2.0, 2.0, 14.0, fluid_z, 0.995, color, light);
            this.drawQuad(EnumFacing.SOUTH, texture, 2.0, 2.0, 14.0, fluid_z, 15.005, color, light);
            this.drawQuad(EnumFacing.EAST, texture, 2.0, 2.0, 14.0, fluid_z, 0.995, color, light);
            this.drawQuad(EnumFacing.WEST, texture, 2.0, 2.0, 14.0, fluid_z, 15.005, color, light);
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
        }
    }
}

