/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity.renderer;

import exter.foundry.block.BlockFoundrySidedMachine;
import exter.foundry.block.BlockRefractorySpout;
import exter.foundry.tileentity.TileEntityRefractorySpout;
import exter.foundry.tileentity.renderer.ISpoutPourDepth;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SpoutRenderer
extends TileEntitySpecialRenderer<TileEntityRefractorySpout> {
    private void drawQuad(EnumFacing facing, TextureAtlasSprite texture, double x1, double y1, double x2, double y2, double z, int color, int light) {
        this.drawQuad(facing, texture, x1, y1, x2, y2, z, 0.0, 0.0, color, light);
    }

    private void drawQuad(EnumFacing facing, TextureAtlasSprite texture, double x1, double y1, double x2, double y2, double z, double u, double v, int color, int light) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        double u1 = texture.func_94214_a(x1 + u);
        double v1 = texture.func_94207_b(y1 + v);
        double u2 = texture.func_94214_a(x2 + u);
        double v2 = texture.func_94207_b(y2 + v);
        int l1 = light >> 16 & 0xFFFF;
        int l2 = light & 0xFFFF;
        x1 /= 16.0;
        y1 /= 16.0;
        x2 /= 16.0;
        y2 /= 16.0;
        z /= 16.0;
        VertexBuffer tessellator = Tessellator.func_178181_a().func_178180_c();
        tessellator.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        switch (facing) {
            case EAST: 
            case WEST: {
                tessellator.func_181662_b(z, y2, x1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y2, x2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y1, x2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(z, y1, x1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                break;
            }
            case SOUTH: 
            case NORTH: {
                tessellator.func_181662_b(x2, y2, z).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, y2, z).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, y1, z).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, y1, z).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                break;
            }
            case UP: 
            case DOWN: {
                tessellator.func_181662_b(x2, z, y2).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, z, y2).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x1, z, y1).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(l1, l2).func_181675_d();
                tessellator.func_181662_b(x2, z, y1).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(l1, l2).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public void renderTileEntityAt(TileEntityRefractorySpout te, double x, double y, double z, float partialTicks, int destroyStage) {
        FluidStack fluid = te.getTank(1).getFluid();
        if (fluid != null) {
            GL11.glPushMatrix();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179118_c();
            GlStateManager.func_179129_p();
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179117_G();
            GlStateManager.func_179109_b((float)((float)(x + 0.5)), (float)((float)y), (float)((float)(z + 0.5)));
            switch ((BlockFoundrySidedMachine.EnumMachineFacing)((Object)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockRefractorySpout.FACING))) {
                case EAST: {
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
            GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
            double low = 0.0;
            BlockPos pos = te.func_174877_v();
            if (pos.func_177956_o() > 0) {
                pos = pos.func_177979_c(te.getPourLength() + 1);
                World world = te.func_145831_w();
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof ISpoutPourDepth) {
                    low = ((ISpoutPourDepth)state.func_177230_c()).getSpoutPourDepth(world, pos, state) - 16;
                } else {
                    AxisAlignedBB bounds = state.func_185890_d(world, pos);
                    if (bounds != null) {
                        low = bounds.field_72337_e * 16.0 - 15.75;
                    }
                }
                if (low > 0.0) {
                    low = 0.0;
                }
                if (low < -16.0) {
                    low = -16.0;
                }
            }
            int color = fluid.getFluid().getColor();
            int light = te.func_145831_w().func_175626_b(te.func_174877_v(), fluid.getFluid().getLuminosity());
            this.drawQuad(EnumFacing.UP, texture, 7.0, 3.0, 9.0, 9.0, 8.75, color, light);
            this.drawQuad(EnumFacing.EAST, texture, 7.0, 0.0, 9.0, 8.75, 7.0, color, light);
            this.drawQuad(EnumFacing.WEST, texture, 7.0, 0.0, 9.0, 8.75, 9.0, color, light);
            this.drawQuad(EnumFacing.SOUTH, texture, 7.0, 0.0, 9.0, 8.75, 9.0, color, light);
            this.drawQuad(EnumFacing.NORTH, texture, 7.0, 0.0, 9.0, 5.0, 7.0, color, light);
            for (int i = 0; i < te.getPourLength(); ++i) {
                int py = -16 * i;
                this.drawQuad(EnumFacing.EAST, texture, 7.0, py - 16, 9.0, py, 7.0, 0.0, 16 - py, color, light);
                this.drawQuad(EnumFacing.WEST, texture, 7.0, py - 16, 9.0, py, 9.0, 0.0, 16 - py, color, light);
                this.drawQuad(EnumFacing.SOUTH, texture, 7.0, py - 16, 9.0, py, 9.0, 0.0, 16 - py, color, light);
                this.drawQuad(EnumFacing.NORTH, texture, 7.0, py - 16, 9.0, py, 7.0, 0.0, 16 - py, color, light);
            }
            if (low < 1.0E-4) {
                int py = -16 * te.getPourLength();
                this.drawQuad(EnumFacing.EAST, texture, 7.0, low + (double)py, 9.0, py, 7.0, 0.0, 16 - py, color, light);
                this.drawQuad(EnumFacing.WEST, texture, 7.0, low + (double)py, 9.0, py, 9.0, 0.0, 16 - py, color, light);
                this.drawQuad(EnumFacing.SOUTH, texture, 7.0, low + (double)py, 9.0, py, 9.0, 0.0, 16 - py, color, light);
                this.drawQuad(EnumFacing.NORTH, texture, 7.0, low + (double)py, 9.0, py, 7.0, 0.0, 16 - py, color, light);
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
        }
    }
}

