/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity.renderer;

import exter.foundry.tileentity.TileEntityCastingTableBase;
import exter.foundry.util.hashstack.HashableItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CastingTableRenderer
extends TileEntitySpecialRenderer<TileEntityCastingTableBase> {
    private final double left;
    private final double right;
    private final double top;
    private final double bottom;
    private final double low;
    private final double high;
    private final String item_texture;
    private Map<HashableItem, Integer> colors;
    private static final EnumFacing[] facings = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST};

    public CastingTableRenderer(int left, int right, int top, int bottom, int low, int high, String item_texture) {
        this.left = (double)left / 16.0 - 0.005;
        this.right = (double)right / 16.0 + 0.005;
        this.top = (double)top / 16.0 - 0.005;
        this.bottom = (double)bottom / 16.0 + 0.005;
        this.low = (double)low / 16.0 + 0.01;
        this.high = ((double)high - 0.1) / 16.0;
        this.item_texture = item_texture;
        this.colors = new HashMap<HashableItem, Integer>();
    }

    protected int getItemColor(ItemStack stack) {
        Integer color = HashableItem.getFromMap(this.colors, stack);
        if (color == null) {
            int r = 0;
            int g = 0;
            int b = 0;
            int count = 0;
            for (EnumFacing facing : facings) {
                List quads = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, this.func_178459_a(), (EntityLivingBase)Minecraft.func_71410_x().field_71439_g).func_188616_a(null, facing, 0L);
                if (quads == null) continue;
                for (BakedQuad q : quads) {
                    TextureAtlasSprite texture = q.func_187508_a();
                    for (int i = 0; i < texture.func_110970_k(); ++i) {
                        int[] pixels = texture.func_147965_a(i)[0];
                        int w = texture.func_94211_a();
                        int h = texture.func_94216_b();
                        for (int y = 1; y < h - 1; ++y) {
                            for (int x = 1; x < w - 1; ++x) {
                                int j = y * w + x;
                                int p = pixels[j];
                                int a = p >>> 24 & 0xFF;
                                if (a <= 127) continue;
                                int a1 = pixels[j - 1] >>> 24 & 0xFF;
                                int a2 = pixels[j + 1] >>> 24 & 0xFF;
                                int a3 = pixels[j - w] >>> 24 & 0xFF;
                                int a4 = pixels[j + w] >>> 24 & 0xFF;
                                if (a1 <= 127 || a2 <= 127 || a3 <= 127 || a4 <= 127) continue;
                                r += p & 0xFF;
                                g += p >>> 8 & 0xFF;
                                b += p >>> 16 & 0xFF;
                                ++count;
                            }
                        }
                    }
                }
            }
            color = 0xFF000000 | (r /= count) & 0xFF | ((g /= count) & 0xFF) << 8 | ((b /= count) & 0xFF) << 16;
            this.colors.put(new HashableItem(stack), color);
        }
        return color;
    }

    protected TextureAtlasSprite getItemTexture(ItemStack stack) {
        return Minecraft.func_71410_x().func_147117_R().getTextureExtry(this.item_texture);
    }

    protected boolean uvLockItem() {
        return true;
    }

    public void renderTileEntityAt(TileEntityCastingTableBase te, double x, double y, double z, float partialTicks, int destroyStage) {
        FluidStack fluid = te.getTank(0).getFluid();
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179117_G();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        if (te.func_70301_a(0) != null) {
            ItemStack stack = te.func_70301_a(0);
            TextureAtlasSprite texture = this.getItemTexture(stack);
            int color = this.getItemColor(stack);
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            boolean lock = this.uvLockItem();
            double min_u = texture.func_94214_a((lock ? this.left : 0.0) * 16.0);
            double min_v = texture.func_94207_b((lock ? this.top : 0.0) * 16.0);
            double max_u = texture.func_94214_a((lock ? this.right : 1.0) * 16.0);
            double max_v = texture.func_94207_b((lock ? this.bottom : 1.0) * 16.0);
            if (fluid != null) {
                GlStateManager.func_179132_a((boolean)false);
            }
            VertexBuffer tessellator = Tessellator.func_178181_a().func_178180_c();
            tessellator.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            tessellator.func_181662_b(this.left, this.high, this.bottom).func_187315_a(min_u, max_v).func_181666_a(red, green, blue, alpha).func_181675_d();
            tessellator.func_181662_b(this.right, this.high, this.bottom).func_187315_a(max_u, max_v).func_181666_a(red, green, blue, alpha).func_181675_d();
            tessellator.func_181662_b(this.right, this.high, this.top).func_187315_a(max_u, min_v).func_181666_a(red, green, blue, alpha).func_181675_d();
            tessellator.func_181662_b(this.left, this.high, this.top).func_187315_a(min_u, min_v).func_181666_a(red, green, blue, alpha).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            if (fluid != null) {
                GlStateManager.func_179132_a((boolean)true);
            }
        }
        if (fluid != null) {
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
            int color = fluid.getFluid().getColor();
            int light = te.func_145831_w().func_175626_b(te.func_174877_v(), fluid.getFluid().getLuminosity());
            double progress = (double)te.getProgress() / 300.0;
            progress = Math.sqrt(progress);
            if (te.func_70301_a(0) == null) {
                progress = 1.0;
            }
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f * (float)progress;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            int l1 = light >> 16 & 0xFFFF;
            int l2 = light & 0xFFFF;
            double min_u = texture.func_94214_a(this.left * 16.0);
            double min_v = texture.func_94207_b(this.top * 16.0);
            double max_u = texture.func_94214_a(this.right * 16.0);
            double max_v = texture.func_94207_b(this.bottom * 16.0);
            double fluid_z = (double)fluid.amount / (double)te.getTank(0).getCapacity() * (this.high - this.low) + this.low;
            VertexBuffer tessellator = Tessellator.func_178181_a().func_178180_c();
            tessellator.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            tessellator.func_181662_b(this.left, fluid_z, this.bottom).func_181666_a(red, green, blue, alpha).func_187315_a(min_u, max_v).func_187314_a(l1, l2).func_181675_d();
            tessellator.func_181662_b(this.right, fluid_z, this.bottom).func_181666_a(red, green, blue, alpha).func_187315_a(max_u, max_v).func_187314_a(l1, l2).func_181675_d();
            tessellator.func_181662_b(this.right, fluid_z, this.top).func_181666_a(red, green, blue, alpha).func_187315_a(max_u, min_v).func_187314_a(l1, l2).func_181675_d();
            tessellator.func_181662_b(this.left, fluid_z, this.top).func_181666_a(red, green, blue, alpha).func_187315_a(min_u, min_v).func_187314_a(l1, l2).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }
}

