/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.block.BlockFoundrySidedMachine;
import exter.foundry.block.BlockRefractorySpout;
import exter.foundry.tileentity.TileEntityFoundry;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityRefractorySpout
extends TileEntityFoundry
implements net.minecraftforge.fluids.IFluidHandler {
    private FluidTank fluid_moved = new FluidTank(10);
    private IFluidHandler fluid_handler = new FluidHandler();
    private int pour_length = 0;
    private int next_move = 2;

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        EnumFacing side = ((BlockFoundrySidedMachine.EnumMachineFacing)((Object)this.field_145850_b.func_180495_p((BlockPos)this.func_174877_v()).func_177229_b((IProperty)BlockRefractorySpout.FACING))).facing;
        return facing == EnumFacing.DOWN || facing == side ? this.fluid_handler : null;
    }

    public int getPourLength() {
        return this.pour_length;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("next_move")) {
            this.next_move = compund.func_74762_e("next_move");
        }
        if (compund.func_74764_b("pour_length")) {
            this.pour_length = compund.func_74762_e("pour_length");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("next_move", this.next_move);
        compound.func_74768_a("pour_length", this.pour_length);
        return compound;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    protected void updateClient() {
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private static boolean areFluidStacksEqual(FluidStack a, FluidStack b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.isFluidStackIdentical(b);
    }

    @Override
    protected void updateServer() {
        if (--this.next_move == 0) {
            this.next_move = 2;
            FluidStack last_moved = this.fluid_moved.getFluid();
            this.fluid_moved.setFluid(null);
            if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BlockFoundrySidedMachine.STATE) == BlockFoundrySidedMachine.EnumMachineState.ON) {
                FluidStack drained = null;
                EnumFacing side = ((BlockFoundrySidedMachine.EnumMachineFacing)((Object)this.field_145850_b.func_180495_p((BlockPos)this.func_174877_v()).func_177229_b((IProperty)BlockRefractorySpout.FACING))).facing;
                TileEntity source = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a(side.func_176730_m()));
                IFluidHandler hsource = null;
                side = side.func_176734_d();
                if (source != null && source.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                    hsource = (IFluidHandler)source.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
                    drained = hsource.drain(10, false);
                }
                if (drained != null) {
                    BlockPos pos;
                    int down = 0;
                    while ((pos = this.func_174877_v().func_177979_c(++down)).func_177956_o() >= 0) {
                        IBlockState state = this.field_145850_b.func_180495_p(pos);
                        if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, pos)) continue;
                        TileEntity dest = this.field_145850_b.func_175625_s(pos);
                        if (dest == null || !dest.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) break;
                        IFluidHandler hdest = (IFluidHandler)dest.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
                        if (drained == null) break;
                        drained.amount = hdest.fill(drained, false);
                        if (drained.amount <= 0) break;
                        hsource.drain(drained.amount, true);
                        hdest.fill(drained, true);
                        this.fluid_moved.setFluid(drained.copy());
                        this.pour_length = down - 1;
                        this.updateValue("pour_length", this.pour_length);
                        break;
                    }
                }
            }
            if (!TileEntityRefractorySpout.areFluidStacksEqual(this.fluid_moved.getFluid(), last_moved)) {
                this.updateTank(0);
            }
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        return this.fluid_moved;
    }

    @Override
    public int getTankCount() {
        return 1;
    }

    @Override
    protected void onInitialize() {
    }

    protected class FluidHandler
    implements IFluidHandler {
        private IFluidTankProperties[] props = new IFluidTankProperties[0];

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

