/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.block.BlockRefractoryHopper;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.util.FoundryMiscUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityRefractoryHopper
extends TileEntityFoundry
implements ISidedInventory,
net.minecraftforge.fluids.IFluidHandler {
    public static final int INVENTORY_CONTAINER_DRAIN = 0;
    public static final int INVENTORY_CONTAINER_FILL = 1;
    private FluidTank tank;
    private IFluidHandler fluid_handler;
    private int next_drain = 12;
    private int next_world_drain = 300;
    private int next_fill = 3;
    private boolean[] visited = new boolean[33620];
    private static final int[] SLOTS = new int[0];

    public TileEntityRefractoryHopper() {
        this.tank = new FluidTank(2000);
        this.fluid_handler = new FluidHandler();
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 0, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 1, true));
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        EnumFacing side = ((BlockRefractoryHopper.EnumHopperFacing)((Object)this.field_145850_b.func_180495_p((BlockPos)this.func_174877_v()).func_177229_b(BlockRefractoryHopper.FACING))).facing;
        return facing == EnumFacing.UP || facing == side ? this.fluid_handler : null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("next_drain")) {
            this.next_drain = compund.func_74762_e("next_drain");
        }
        if (compund.func_74764_b("next_world_drain")) {
            this.next_world_drain = compund.func_74762_e("next_world_drain");
        }
        if (compund.func_74764_b("next_fill")) {
            this.next_fill = compund.func_74762_e("next_fill");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("next_drain", this.next_drain);
        compound.func_74768_a("next_world_drain", this.next_world_drain);
        compound.func_74768_a("next_fill", this.next_fill);
        return compound;
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing side) {
        return false;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        if (--this.next_world_drain == 0) {
            Fluid drainfluid;
            this.next_world_drain = 300;
            FluidStack todrain = FoundryMiscUtils.drainFluidFromWorld(this.field_145850_b, this.func_174877_v().func_177982_a(0, 1, 0), false);
            if (todrain != null && this.tank.fill(todrain, false) == todrain.amount && !(drainfluid = todrain.getFluid()).isGaseous(todrain) && drainfluid.getDensity(todrain) >= 0) {
                int i;
                for (i = 0; i < 33620; ++i) {
                    this.visited[i] = false;
                }
                ArrayList<Integer> queue = new ArrayList<Integer>();
                HashSet<Integer> newqueue = new HashSet<Integer>();
                i = 16420;
                this.visited[i] = true;
                int top_y = 0;
                queue.add(i - 1);
                queue.add(i + 1);
                queue.add(i - 820);
                queue.add(i + 820);
                queue.add(i + 41);
                int drainblock = i;
                do {
                    newqueue.clear();
                    Iterator iterator = queue.iterator();
                    while (iterator.hasNext()) {
                        int p = (Integer)iterator.next();
                        int x = p % 41;
                        int y = p / 41 % 20;
                        int z = p / 820;
                        todrain = FoundryMiscUtils.drainFluidFromWorld(this.field_145850_b, this.func_174877_v().func_177982_a(x - 20, y + 1, z - 20), false);
                        if (todrain != null && todrain.getFluid() == drainfluid && this.tank.fill(todrain, false) == todrain.amount) {
                            if (y > top_y) {
                                top_y = y;
                            }
                            if (y == top_y) {
                                drainblock = p;
                            }
                            if (x > 0 && !this.visited[p - 1]) {
                                newqueue.add(p - 1);
                            }
                            if (x < 40 && !this.visited[p + 1]) {
                                newqueue.add(p + 1);
                            }
                            if (z > 0 && !this.visited[p - 820]) {
                                newqueue.add(p - 820);
                            }
                            if (z < 40 && !this.visited[p + 820]) {
                                newqueue.add(p + 820);
                            }
                            if (y < 19 && !this.visited[p + 41]) {
                                newqueue.add(p + 41);
                            }
                        }
                        this.visited[p] = true;
                    }
                    queue.clear();
                    queue.addAll(newqueue);
                } while (!queue.isEmpty());
                int x = drainblock % 41;
                int z = drainblock / 820;
                todrain = FoundryMiscUtils.drainFluidFromWorld(this.field_145850_b, this.func_174877_v().func_177982_a(x - 20, top_y + 1, z - 20), true);
                this.tank.fill(todrain, true);
                this.updateTank(0);
                this.func_70296_d();
            }
        }
        if (--this.next_drain == 0) {
            IFluidHandler hsource;
            FluidStack drained;
            this.next_drain = 12;
            TileEntity source = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, 1, 0));
            if (source != null && source.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) && (drained = (hsource = (IFluidHandler)source.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)).drain(40, false)) != null && !drained.getFluid().isGaseous(drained) && drained.getFluid().getDensity(drained) > 0) {
                drained.amount = this.tank.fill(drained, false);
                if (drained.amount > 0) {
                    hsource.drain(drained, true);
                    this.tank.fill(drained, true);
                    this.updateTank(0);
                    this.func_70296_d();
                }
            }
        }
        if (--this.next_fill == 0) {
            this.next_fill = 3;
            if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0) {
                EnumFacing side = ((BlockRefractoryHopper.EnumHopperFacing)((Object)this.field_145850_b.func_180495_p((BlockPos)this.func_174877_v()).func_177229_b(BlockRefractoryHopper.FACING))).facing;
                TileEntity dest = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a(side.func_176730_m()));
                side = side.func_176734_d();
                if (dest != null && dest.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                    IFluidHandler hdest = (IFluidHandler)dest.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
                    FluidStack drained = this.tank.drain(10, false);
                    if (drained != null) {
                        drained.amount = hdest.fill(drained, false);
                        if (drained.amount > 0) {
                            this.tank.drain(drained.amount, true);
                            hdest.fill(drained, true);
                            this.updateTank(0);
                            this.func_70296_d();
                        }
                    }
                }
            }
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        return this.tank;
    }

    @Override
    public int getTankCount() {
        return 1;
    }

    @Override
    protected void onInitialize() {
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    protected class FluidHandler
    implements IFluidHandler {
        private IFluidTankProperties[] props;

        public FluidHandler() {
            this.props = new IFluidTankProperties[TileEntityRefractoryHopper.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityRefractoryHopper.this.getTank(i));
            }
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int result = TileEntityRefractoryHopper.this.fillTank(0, resource, doFill);
            if (doFill && resource != null && result > 0) {
                TileEntityRefractoryHopper.this.next_drain = 12;
            }
            return result;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

