/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.api.recipe.IMoldRecipe;
import exter.foundry.block.BlockMoldStation;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemComponent;
import exter.foundry.recipes.manager.MoldRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.item.IExoflameHeatable;

@Optional.Interface(iface="vazkii.botania.api.item.IExoflameHeatable", modid="Botania")
public class TileEntityMoldStation
extends TileEntityFoundry
implements IExoflameHeatable {
    public static final int SLOT_BLOCK = 0;
    public static final int SLOT_CLAY = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_FUEL = 3;
    private int burn_time = 0;
    private int item_burn_time = 0;
    private int progress = 0;
    private boolean has_block = false;
    private boolean update_burn_times = false;
    private int[] grid = new int[36];
    private IMoldRecipe current_recipe = null;

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("BurnTime")) {
            this.burn_time = tag.func_74762_e("BurnTime");
        }
        if (tag.func_74764_b("CookTime")) {
            this.progress = tag.func_74762_e("CookTime");
        }
        if (tag.func_74764_b("ItemBurnTime")) {
            this.item_burn_time = tag.func_74762_e("ItemBurnTime");
        }
        boolean grid_changed = false;
        for (int i = 0; i < 36; ++i) {
            if (!tag.func_74764_b("RecipeGrid_" + i)) continue;
            this.grid[i] = tag.func_74762_e("RecipeGrid_" + i);
            grid_changed = true;
        }
        if (tag.func_74764_b("HasBlock")) {
            this.has_block = tag.func_74767_n("HasBlock");
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.has_block) {
            if (grid_changed) {
                this.current_recipe = null;
            }
            if (tag.func_74764_b("command_fire")) {
                this.current_recipe = MoldRecipeManager.instance.findRecipe(this.grid);
            }
            ((BlockMoldStation)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
        }
    }

    public int getBurningTime() {
        return this.burn_time;
    }

    public int getItemBurnTime() {
        return this.item_burn_time;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean hasBlock() {
        return this.has_block;
    }

    public int getGridSlot(int slot) {
        return this.grid[slot];
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burn_time);
        compound.func_74768_a("CookTime", this.progress);
        compound.func_74768_a("ItemBurnTime", this.item_burn_time);
        for (int i = 0; i < 36; ++i) {
            compound.func_74768_a("RecipeGrid_" + i, this.grid[i]);
        }
        compound.func_74757_a("HasBlock", this.has_block);
        return compound;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burn_time > 0;
    }

    @Override
    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : par1EntityPlayer.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 2: {
                return false;
            }
            case 3: {
                return TileEntityFurnace.func_145954_b((ItemStack)stack);
            }
        }
        return true;
    }

    public boolean canInsertItem(int par1, ItemStack par2ItemStack, EnumFacing side) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    @Override
    protected void updateClient() {
    }

    private boolean canOutput(ItemStack output, int slot) {
        ItemStack inv_output = this.inventory[slot];
        return output == null || inv_output == null || inv_output.func_77969_a(output) && inv_output.field_77994_a - output.field_77994_a <= inv_output.func_77976_d();
    }

    private int getCarvedClayAmount() {
        int amount = 0;
        for (int g : this.grid) {
            amount += g;
        }
        return amount /= 10;
    }

    private boolean canRecipeOutput() {
        ItemStack output = this.current_recipe.getOutput();
        int clay_amount = this.getCarvedClayAmount();
        ItemStack slot_clay = this.inventory[1];
        return this.canOutput(output, 2) && (slot_clay == null || slot_clay.field_77994_a + clay_amount <= slot_clay.func_77976_d());
    }

    private void clearGrid() {
        for (int i = 0; i < 36; ++i) {
            if (this.grid[i] <= 0) continue;
            this.grid[i] = 0;
            this.updateValue("RecipeGrid_" + i, this.grid[i]);
        }
        this.current_recipe = null;
    }

    private void doSmelt() {
        if (!this.canRecipeOutput()) {
            this.progress = 0;
            return;
        }
        ItemStack output = this.current_recipe.getOutput();
        int clay = this.getCarvedClayAmount();
        if (++this.progress == 200) {
            this.progress = 0;
            if (this.inventory[2] == null) {
                this.inventory[2] = output.func_77946_l();
            } else {
                this.inventory[2].field_77994_a += output.field_77994_a;
            }
            if (this.inventory[1] == null) {
                this.inventory[1] = FoundryItems.component(ItemComponent.SubItem.REFRACTORYCLAY_SMALL, clay);
            } else {
                this.inventory[1].field_77994_a += clay;
            }
            this.updateInventoryItem(2);
            this.updateInventoryItem(1);
            this.has_block = false;
            this.updateValue("HasBlock", this.has_block);
            this.clearGrid();
        }
    }

    @Override
    protected void updateServer() {
        ItemStack block;
        int last_burn_time = this.burn_time;
        int last_progress = this.progress;
        int last_item_burn_time = this.item_burn_time;
        if (!this.has_block && (block = this.func_70301_a(0)) != null) {
            this.func_70298_a(0, 1);
            this.has_block = true;
            this.updateValue("HasBlock", this.has_block);
            this.clearGrid();
        }
        if (this.burn_time > 0) {
            --this.burn_time;
        }
        if (this.has_block && this.progress >= 0) {
            if (this.burn_time == 0 && this.current_recipe != null && this.canRecipeOutput()) {
                this.item_burn_time = this.burn_time = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[3]);
                if (this.burn_time > 0 && this.inventory[3] != null) {
                    if (--this.inventory[3].field_77994_a == 0) {
                        this.inventory[3] = this.inventory[3].func_77973_b().getContainerItem(this.inventory[3]);
                    }
                    this.updateInventoryItem(3);
                }
            }
            if (this.burn_time > 0) {
                if (this.current_recipe != null) {
                    this.doSmelt();
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
        }
        if (last_burn_time != this.burn_time || this.update_burn_times) {
            if (last_burn_time * this.burn_time == 0) {
                ((BlockMoldStation)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
            }
            this.updateValue("BurnTime", this.burn_time);
        }
        if (last_item_burn_time != this.item_burn_time || this.update_burn_times) {
            this.updateValue("ItemBurnTime", this.item_burn_time);
        }
        this.update_burn_times = false;
        if (last_progress != this.progress) {
            this.updateValue("CookTime", this.progress);
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    @Override
    protected void onInitialize() {
        this.current_recipe = null;
    }

    public void carve(int x1, int y1, int x2, int y2) {
        if (this.field_145850_b.field_72995_K && this.has_block) {
            NBTTagCompound tag = new NBTTagCompound();
            for (int j = y1; j <= y2; ++j) {
                for (int i = x1; i <= x2; ++i) {
                    int slot = j * 6 + i;
                    if (this.grid[slot] >= 4) continue;
                    int n = slot;
                    this.grid[n] = this.grid[n] + 1;
                    tag.func_74768_a("RecipeGrid_" + slot, this.grid[slot]);
                }
            }
            this.sendToServer(tag);
        }
    }

    public void mend(int x1, int y1, int x2, int y2) {
        if (this.field_145850_b.field_72995_K && this.has_block) {
            NBTTagCompound tag = new NBTTagCompound();
            for (int j = y1; j <= y2; ++j) {
                for (int i = x1; i <= x2; ++i) {
                    int slot = j * 6 + i;
                    if (this.grid[slot] <= 0) continue;
                    int n = slot;
                    this.grid[n] = this.grid[n] - 1;
                    tag.func_74768_a("RecipeGrid_" + slot, this.grid[slot]);
                }
            }
            this.sendToServer(tag);
        }
    }

    public void fire() {
        if (this.field_145850_b.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("command_fire", true);
            this.sendToServer(tag);
        }
    }

    @Optional.Method(modid="Botania")
    public boolean canSmelt() {
        return this.has_block && this.current_recipe != null && this.canRecipeOutput();
    }

    @Optional.Method(modid="Botania")
    public int getBurnTime() {
        return this.burn_time <= 1 ? 0 : this.burn_time - 1;
    }

    @Optional.Method(modid="Botania")
    public void boostBurnTime() {
        if (!this.field_145850_b.field_72995_K) {
            this.burn_time = 200;
            this.item_burn_time = 199;
            this.update_burn_times = true;
            this.func_70296_d();
        }
    }

    @Optional.Method(modid="Botania")
    public void boostCookTime() {
    }
}

