/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityFoundryPowered;
import java.util.Set;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMetalCaster
extends TileEntityFoundryPowered
implements ISidedInventory,
net.minecraftforge.fluids.IFluidHandler {
    public static final int CAST_TIME = 400000;
    public static final int ENERGY_REQUIRED = 10000;
    public static final int INVENTORY_OUTPUT = 0;
    public static final int INVENTORY_MOLD = 1;
    public static final int INVENTORY_EXTRA = 2;
    public static final int INVENTORY_CONTAINER_DRAIN = 3;
    public static final int INVENTORY_CONTAINER_FILL = 4;
    public static final int INVENTORY_MOLD_STORAGE = 5;
    public static final int INVENTORY_MOLD_STORAGE_SIZE = 9;
    @Deprecated
    private static final int[] INSERT_SLOTS = new int[]{2};
    @Deprecated
    private static final int[] EXTRACT_SLOTS = new int[]{0};
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)2);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of((Object)0);
    private FluidTank tank = new FluidTank(6000);
    private IFluidHandler fluid_handler = new TileEntityFoundry.FluidHandler(0, 0);
    private TileEntityFoundry.ItemHandler item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
    private ICastingRecipe current_recipe = null;
    private int progress;

    public TileEntityMetalCaster() {
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 3, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 4, true));
        this.update_energy = true;
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("progress")) {
            this.progress = compund.func_74762_e("progress");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("progress", this.progress);
        return compound;
    }

    public int func_70302_i_() {
        return 14;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 2;
    }

    @Deprecated
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.UP ? INSERT_SLOTS : EXTRACT_SLOTS;
    }

    @Deprecated
    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slot, itemstack);
    }

    @Deprecated
    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        return slot == 0;
    }

    @Override
    protected void updateClient() {
    }

    private void checkCurrentRecipe() {
        if (this.current_recipe == null) {
            this.progress = -1;
            return;
        }
        if (!this.current_recipe.matchesRecipe(this.inventory[1], this.tank.getFluid(), this.inventory[2])) {
            this.progress = -1;
            this.current_recipe = null;
            return;
        }
    }

    private void beginCasting() {
        if (this.current_recipe != null && this.canCastCurrentRecipe() && this.getStoredFoundryEnergy() >= 10000L) {
            this.useFoundryEnergy(10000L, true);
            this.progress = 0;
        }
    }

    private boolean canCastCurrentRecipe() {
        if (this.current_recipe.requiresExtra() && !this.current_recipe.containsExtra(this.inventory[2])) {
            return false;
        }
        ItemStack recipe_output = this.current_recipe.getOutput();
        ItemStack inv_output = this.inventory[0];
        return inv_output == null || inv_output.func_77969_a(recipe_output) && inv_output.field_77994_a + recipe_output.field_77994_a <= inv_output.func_77976_d();
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        int last_progress = this.progress;
        this.checkCurrentRecipe();
        if (this.current_recipe == null) {
            this.current_recipe = CastingRecipeManager.instance.findRecipe(this.tank.getFluid(), this.inventory[1], this.inventory[2]);
            this.progress = -1;
        }
        if (this.progress < 0) {
            switch (this.getRedstoneMode()) {
                case RSMODE_IGNORE: {
                    this.beginCasting();
                    break;
                }
                case RSMODE_OFF: {
                    if (this.redstone_signal) break;
                    this.beginCasting();
                    break;
                }
                case RSMODE_ON: {
                    if (!this.redstone_signal) break;
                    this.beginCasting();
                    break;
                }
                case RSMODE_PULSE: {
                    if (!this.redstone_signal || this.last_redstone_signal) break;
                    this.beginCasting();
                }
            }
        } else if (this.canCastCurrentRecipe()) {
            FluidStack input_fluid = this.current_recipe.getInput();
            int increment = 18000 * this.current_recipe.getCastingSpeed() / input_fluid.amount;
            if (increment > 100000) {
                increment = 100000;
            }
            if (increment < 1) {
                increment = 1;
            }
            this.progress += increment;
            if (this.progress >= 400000) {
                this.progress = -1;
                this.tank.drain(input_fluid.amount, true);
                if (this.current_recipe.requiresExtra()) {
                    this.func_70298_a(2, this.current_recipe.getInputExtra().getAmount());
                    this.updateInventoryItem(2);
                }
                if (this.inventory[0] == null) {
                    this.inventory[0] = this.current_recipe.getOutput();
                } else {
                    this.inventory[0].field_77994_a += this.current_recipe.getOutput().field_77994_a;
                }
                this.updateInventoryItem(0);
                this.updateTank(0);
                this.func_70296_d();
            }
        } else {
            this.progress = -1;
        }
        if (last_progress != this.progress) {
            this.updateValue("progress", this.progress);
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        if (slot != 0) {
            return null;
        }
        return this.tank;
    }

    @Override
    public int getTankCount() {
        return 1;
    }

    @Override
    public long getFoundryEnergyCapacity() {
        return 40000L;
    }
}

