/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.recipe.IAtomizerRecipe;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityFoundryPowered;
import java.util.Set;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMetalAtomizer
extends TileEntityFoundryPowered
implements ISidedInventory,
net.minecraftforge.fluids.IFluidHandler {
    public static final int ATOMIZE_TIME = 500000;
    public static final int ENERGY_REQUIRED = 15000;
    public static final int INVENTORY_OUTPUT = 0;
    public static final int INVENTORY_CONTAINER_DRAIN = 1;
    public static final int INVENTORY_CONTAINER_FILL = 2;
    public static final int INVENTORY_CONTAINER_WATER_DRAIN = 3;
    public static final int INVENTORY_CONTAINER_WATER_FILL = 4;
    public static final int TANK_INPUT = 0;
    public static final int TANK_WATER = 1;
    @Deprecated
    private static final int[] EXTRACT_SLOTS = new int[]{0};
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of();
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of((Object)0);
    private FluidTank[] tanks;
    private IFluidHandler fluid_handler;
    private TileEntityFoundry.ItemHandler item_handler;
    IAtomizerRecipe current_recipe;
    private int progress;
    private final FluidStack water_required = new FluidStack(FluidRegistry.WATER, 50);

    public TileEntityMetalAtomizer() {
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(6000);
        this.tanks[1] = new FluidTank(6000);
        this.fluid_handler = new FluidHandler();
        this.item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
        this.progress = -1;
        this.current_recipe = null;
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 1, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 2, true));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(1, 3, false, FluidRegistry.WATER));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(1, 4, true, FluidRegistry.WATER));
        this.update_energy = true;
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("progress")) {
            this.progress = compund.func_74762_e("progress");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("progress", this.progress);
        return compound;
    }

    public int func_70302_i_() {
        return 5;
    }

    public int getProgress() {
        return this.progress;
    }

    @Deprecated
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }

    @Deprecated
    public int[] func_180463_a(EnumFacing side) {
        return EXTRACT_SLOTS;
    }

    @Deprecated
    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slot, itemstack);
    }

    @Deprecated
    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        return slot == 0;
    }

    @Override
    protected void updateClient() {
    }

    private void checkCurrentRecipe() {
        if (this.current_recipe == null) {
            this.progress = -1;
            return;
        }
        if (!this.current_recipe.matchesRecipe(this.tanks[0].getFluid())) {
            this.progress = -1;
            this.current_recipe = null;
            return;
        }
    }

    private void beginAtomizing() {
        if (this.current_recipe != null && this.canAtomizeCurrentRecipe() && this.getStoredFoundryEnergy() >= 15000L) {
            this.useFoundryEnergy(15000L, true);
            this.progress = 0;
        }
    }

    private boolean canAtomizeCurrentRecipe() {
        if (this.tanks[1].getFluid() == null || !this.tanks[1].getFluid().containsFluid(this.water_required)) {
            return false;
        }
        ItemStack recipe_output = this.current_recipe.getOutput();
        ItemStack inv_output = this.inventory[0];
        return inv_output == null || inv_output.func_77969_a(recipe_output) && inv_output.field_77994_a + recipe_output.field_77994_a <= inv_output.func_77976_d();
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        int last_progress = this.progress;
        this.checkCurrentRecipe();
        if (this.current_recipe == null) {
            this.current_recipe = AtomizerRecipeManager.instance.findRecipe(this.tanks[0].getFluid());
            this.progress = -1;
        }
        if (this.progress < 0) {
            switch (this.getRedstoneMode()) {
                case RSMODE_IGNORE: {
                    this.beginAtomizing();
                    break;
                }
                case RSMODE_OFF: {
                    if (this.redstone_signal) break;
                    this.beginAtomizing();
                    break;
                }
                case RSMODE_ON: {
                    if (!this.redstone_signal) break;
                    this.beginAtomizing();
                    break;
                }
                case RSMODE_PULSE: {
                    if (!this.redstone_signal || this.last_redstone_signal) break;
                    this.beginAtomizing();
                }
            }
        } else if (this.canAtomizeCurrentRecipe()) {
            FluidStack input_fluid = this.current_recipe.getInput();
            int increment = 1800000 / input_fluid.amount;
            if (increment > 125000) {
                increment = 125000;
            }
            if (increment < 1) {
                increment = 1;
            }
            this.progress += increment;
            if (this.progress >= 500000) {
                this.progress = -1;
                this.tanks[0].drain(input_fluid.amount, true);
                this.tanks[1].drain(this.water_required.amount, true);
                if (this.inventory[0] == null) {
                    this.inventory[0] = this.current_recipe.getOutput();
                } else {
                    this.inventory[0].field_77994_a += this.current_recipe.getOutput().field_77994_a;
                }
                this.updateInventoryItem(0);
                this.updateTank(0);
                this.updateTank(1);
                this.func_70296_d();
            }
        } else {
            this.progress = -1;
        }
        if (last_progress != this.progress) {
            this.updateValue("progress", this.progress);
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        if (slot < 0 || slot > 1) {
            return null;
        }
        return this.tanks[slot];
    }

    @Override
    public int getTankCount() {
        return 2;
    }

    @Override
    public long getFoundryEnergyCapacity() {
        return 60000L;
    }

    protected class FluidHandler
    implements IFluidHandler {
        private IFluidTankProperties[] props;

        public FluidHandler() {
            this.props = new IFluidTankProperties[TileEntityMetalAtomizer.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityMetalAtomizer.this.getTank(i));
            }
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
                return TileEntityMetalAtomizer.this.fillTank(1, resource, doFill);
            }
            return TileEntityMetalAtomizer.this.fillTank(0, resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityMetalAtomizer.this.drainTank(0, resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityMetalAtomizer.this.drainTank(0, maxDrain, doDrain);
        }
    }
}

