/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityFoundryHeatable;
import java.util.Set;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMeltingCrucible
extends TileEntityFoundryHeatable
implements ISidedInventory,
net.minecraftforge.fluids.IFluidHandler {
    public static final int SMELT_TIME = 5000000;
    public static final int INVENTORY_INPUT = 0;
    public static final int INVENTORY_CONTAINER_DRAIN = 1;
    public static final int INVENTORY_CONTAINER_FILL = 2;
    @Deprecated
    private static final int[] INSERT_SLOTS = new int[]{0};
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of();
    private FluidTank tank = new FluidTank(6000);
    private IFluidHandler fluid_handler = new TileEntityFoundry.FluidHandler(-1, 0);
    private TileEntityFoundry.ItemHandler item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
    private int progress = 0;
    private int melt_point = 0;
    private IMeltingRecipe current_recipe = null;

    public TileEntityMeltingCrucible() {
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 1, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 2, true));
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("progress")) {
            this.progress = compund.func_74762_e("progress");
        }
        if (compund.func_74764_b("melt_point")) {
            this.melt_point = compund.func_74762_e("melt_point");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("melt_point", this.melt_point);
        compound.func_74768_a("progress", this.progress);
        return compound;
    }

    public int func_70302_i_() {
        return 3;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMeltingPoint() {
        return this.melt_point;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0;
    }

    @Deprecated
    public int[] func_180463_a(EnumFacing side) {
        return INSERT_SLOTS;
    }

    @Deprecated
    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(i, itemstack);
    }

    @Deprecated
    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing side) {
        return false;
    }

    @Override
    protected void updateClient() {
    }

    private void checkCurrentRecipe() {
        if (this.current_recipe == null) {
            this.progress = 0;
            return;
        }
        if (!this.current_recipe.matchesRecipe(this.inventory[0])) {
            this.progress = 0;
            this.current_recipe = null;
        }
    }

    private void doMeltingProgress() {
        if (this.current_recipe == null) {
            this.progress = 0;
            this.melt_point = 0;
            return;
        }
        FluidStack fs = this.current_recipe.getOutput();
        this.melt_point = this.current_recipe.getMeltingPoint() * 100;
        int heat = this.getTemperature();
        if (heat <= this.melt_point || this.tank.fill(fs, false) < fs.amount) {
            this.progress = 0;
            return;
        }
        int increment = (heat - this.melt_point) * 5 * this.current_recipe.getMeltingSpeed() / (fs.amount * 4);
        if (increment < 1) {
            increment = 1;
        }
        if (increment > 1250000) {
            increment = 1250000;
        }
        this.progress += increment;
        if (this.progress >= 5000000) {
            this.progress = 0;
            this.tank.fill(fs, true);
            this.func_70298_a(0, this.current_recipe.getInput().getAmount());
            this.updateTank(0);
        }
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        int last_progress = this.progress;
        int last_melt_point = this.melt_point;
        this.checkCurrentRecipe();
        if (this.current_recipe == null) {
            this.current_recipe = MeltingRecipeManager.instance.findRecipe(this.inventory[0]);
        }
        this.doMeltingProgress();
        if (last_progress != this.progress) {
            this.updateValue("progress", this.progress);
        }
        if (last_melt_point != this.melt_point) {
            this.updateValue("melt_point", this.melt_point);
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        if (slot != 0) {
            return null;
        }
        return this.tank;
    }

    @Override
    public int getTankCount() {
        return 1;
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    public int getMaxTemperature() {
        return 200000;
    }

    @Override
    protected int getTemperatureLossRate() {
        return 750;
    }

    @Override
    protected boolean canReceiveHeat() {
        boolean active = true;
        switch (this.getRedstoneMode()) {
            case RSMODE_OFF: {
                if (!this.redstone_signal) break;
                active = false;
                break;
            }
            case RSMODE_ON: {
                if (this.redstone_signal) break;
                active = false;
                break;
            }
        }
        return active;
    }
}

