/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.ModFoundry;
import exter.foundry.material.MaterialRegistry;
import exter.foundry.network.MessageTileEntitySync;
import exter.foundry.tileentity.TileEntityFoundry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMaterialRouter
extends TileEntityFoundry
implements ISidedInventory {
    public static final int SLOT_OUTPUT = 3;
    @Deprecated
    private static int[][] SIDE_SLOTS = new int[][]{{0, 1, 2, 3}, {0, 1, 2, 4}, {0, 1, 2, 5}, {0, 1, 2, 6}, {0, 1, 2, 7}, {0, 1, 2, 8}};
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    private List<Route> routes = new ArrayList<Route>();
    private int input_index = 0;
    public int gui_material_scroll = 0;
    public int gui_type_scroll = 0;
    public int gui_route_scroll = 0;
    public int gui_material_selected = 0;
    public int gui_type_selected = 0;
    private Map<EnumFacing, TileEntityFoundry.ItemHandler> item_handlers = new EnumMap<EnumFacing, TileEntityFoundry.ItemHandler>(EnumFacing.class);

    public TileEntityMaterialRouter() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.item_handlers.put(facing, new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, (Set<Integer>)ImmutableSet.of((Object)(3 + facing.func_176745_a()))));
        }
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        if (side == null) {
            return null;
        }
        return this.item_handlers.get(side);
    }

    public int func_70302_i_() {
        return 9;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.syncRoutes();
        }
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.syncRoutes();
        }
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return slot < 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound routes_tag = (NBTTagCompound)compound.func_74781_a("Routes");
        if (routes_tag != null) {
            this.routes.clear();
            int size = routes_tag.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                NBTTagCompound route_entry_tag = routes_tag.func_74775_l("Route_" + String.valueOf(i));
                this.routes.add(new Route(route_entry_tag));
            }
        }
        if (compound.func_74764_b("gui_material_scroll")) {
            this.gui_material_scroll = compound.func_74762_e("gui_material_scroll");
        }
        if (compound.func_74764_b("gui_type_scroll")) {
            this.gui_type_scroll = compound.func_74762_e("gui_type_scroll");
        }
        if (compound.func_74764_b("gui_route_scroll")) {
            this.gui_route_scroll = compound.func_74762_e("gui_route_scroll");
        }
        if (compound.func_74764_b("gui_material_selected")) {
            this.gui_material_selected = compound.func_74762_e("gui_material_selected");
        }
        if (compound.func_74764_b("gui_type_selected")) {
            this.gui_type_selected = compound.func_74762_e("gui_type_selected");
        }
    }

    private void writeRoutesToNBT(NBTTagCompound compound) {
        NBTTagCompound routes_tag = new NBTTagCompound();
        routes_tag.func_74768_a("size", this.routes.size());
        for (int i = 0; i < this.routes.size(); ++i) {
            NBTTagCompound route_entry_tag = new NBTTagCompound();
            this.routes.get(i).writeToNBT(route_entry_tag);
            routes_tag.func_74782_a("Route_" + String.valueOf(i), (NBTBase)route_entry_tag);
        }
        compound.func_74782_a("Routes", (NBTBase)routes_tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        this.writeRoutesToNBT(compound);
        compound.func_74768_a("gui_material_scroll", this.gui_material_scroll);
        compound.func_74768_a("gui_type_scroll", this.gui_type_scroll);
        compound.func_74768_a("gui_route_scroll", this.gui_route_scroll);
        compound.func_74768_a("gui_material_selected", this.gui_material_selected);
        compound.func_74768_a("gui_type_selected", this.gui_type_selected);
        return compound;
    }

    private void routeItem(int in_slot, int out_slot) {
        ItemStack input = this.inventory[in_slot];
        ItemStack output = this.inventory[out_slot];
        if (output == null) {
            this.inventory[out_slot] = input;
            this.inventory[in_slot] = null;
            this.updateInventoryItem(in_slot);
            this.updateInventoryItem(out_slot);
        } else {
            if (!output.func_77969_a(input) || !ItemStack.func_77970_a((ItemStack)output, (ItemStack)input)) {
                return;
            }
            int transfer = output.func_77976_d() - output.field_77994_a;
            if (transfer > input.field_77994_a) {
                transfer = input.field_77994_a;
            }
            this.func_70298_a(in_slot, transfer);
            this.inventory[out_slot].field_77994_a += transfer;
            this.updateInventoryItem(in_slot);
            this.updateInventoryItem(out_slot);
        }
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        int i;
        ItemStack input;
        if (this.input_index % 4 == 0 && (input = this.inventory[i = this.input_index / 4]) != null) {
            for (Route r : this.routes) {
                if (!r.matchesItem(input)) continue;
                this.routeItem(i, 3 + r.side.func_176745_a());
                break;
            }
        }
        this.input_index = (this.input_index + 1) % 12;
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    @Override
    protected void onInitialize() {
    }

    @Deprecated
    public int[] func_180463_a(EnumFacing side) {
        return SIDE_SLOTS[side.func_176745_a()];
    }

    @Deprecated
    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        return slot < 3;
    }

    @Deprecated
    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return slot == 3 + side.func_176745_a();
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public void syncRoutes() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTileToNBT(tag);
        this.writeRoutesToNBT(tag);
        if (this.field_145850_b.field_72995_K) {
            tag.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
            ModFoundry.network_channel.sendToServer((IMessage)new MessageTileEntitySync(tag));
        } else {
            this.sendPacketToNearbyPlayers(tag);
        }
    }

    public static class Route {
        public String material;
        public String type;
        public EnumFacing side;

        public Route(String route_material, String route_type, EnumFacing route_side) {
            this.material = route_material;
            this.type = route_type;
            this.side = route_side;
        }

        public Route(ByteBuf data) {
            this.material = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.type = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.side = EnumFacing.values()[data.readByte()];
        }

        public Route(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.material = tag.func_74779_i("material");
            this.type = tag.func_74779_i("type");
            this.side = EnumFacing.field_82609_l[tag.func_74771_c("side")];
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("material", this.material);
            tag.func_74778_a("type", this.type);
            tag.func_74774_a("side", (byte)this.side.func_176745_a());
        }

        public boolean matchesItem(ItemStack stack) {
            String stack_type;
            String stack_material;
            ModFoundry.log.info("Item: " + stack.func_77977_a());
            ModFoundry.log.info("Material: " + MaterialRegistry.instance.getMaterial(stack));
            ModFoundry.log.info("Type: " + MaterialRegistry.instance.getType(stack));
            if (!this.material.equals("_Any") && !this.material.equals(stack_material = MaterialRegistry.instance.getMaterial(stack))) {
                return false;
            }
            return this.type.equals("_Any") || this.type.equals(stack_type = MaterialRegistry.instance.getType(stack));
        }

        public void writeToPacket(ByteBuf data) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.material);
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.type);
            data.writeByte(this.side.func_176745_a());
        }
    }
}

