/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import cofh.api.energy.IEnergyReceiver;
import exter.foundry.tileentity.TileEntityFoundry;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public abstract class TileEntityFoundryPowered
extends TileEntityFoundry
implements IEnergyReceiver {
    protected boolean update_energy = false;
    protected boolean update_energy_tick = true;
    public static int RATIO_RF = 10;
    public static int RATIO_TESLA = 10;
    public static int RATIO_EU = 40;
    private long energy_stored;
    private final TeslaConsumer tesla = Loader.isModLoaded((String)"Tesla") ? new TeslaConsumer() : null;

    public abstract long getFoundryEnergyCapacity();

    private long receiveFoundryEnergy(long en, boolean do_receive, boolean allow_overflow) {
        long needed;
        if (!allow_overflow && en > (needed = this.getFoundryEnergyCapacity() - this.energy_stored)) {
            en = needed;
        }
        if (do_receive) {
            this.energy_stored += en;
            if (en > 0L && this.update_energy && !this.field_145850_b.field_72995_K) {
                this.update_energy_tick = true;
            }
        }
        return en;
    }

    public long useFoundryEnergy(long amount, boolean do_use) {
        if (amount > this.energy_stored) {
            amount = this.energy_stored;
        }
        if (do_use) {
            this.energy_stored -= amount;
            this.updateFoundryEnergy();
        }
        return amount;
    }

    public long getStoredFoundryEnergy() {
        long capacity = this.getFoundryEnergyCapacity();
        if (this.energy_stored > capacity) {
            return capacity;
        }
        return this.energy_stored;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("energy")) {
            this.energy_stored = compound.func_74763_f("energy");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74772_a("energy", this.energy_stored);
        return compound;
    }

    @Override
    protected void onInitialize() {
        this.update_energy_tick = true;
    }

    private void updateFoundryEnergy() {
        if (this.update_energy) {
            this.updateValue("energy", this.energy_stored);
        }
    }

    @Override
    protected void updateServer() {
        if (this.update_energy_tick) {
            this.updateFoundryEnergy();
            this.update_energy_tick = false;
        }
    }

    @Override
    public void updateRedstone() {
        this.redstone_signal = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return (int)(this.receiveFoundryEnergy(maxReceive * RATIO_RF, !simulate, false) / (long)RATIO_RF);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return (int)this.getStoredFoundryEnergy() / RATIO_RF;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)this.getFoundryEnergyCapacity() / RATIO_RF;
    }

    @Override
    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (this.tesla != null) {
            return this.hasTeslaCapability(cap, facing);
        }
        return super.hasCapability(cap, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (this.tesla != null) {
            return this.getTeslaCapability(cap, facing);
        }
        return super.getCapability(cap, facing);
    }

    @Optional.Method(modid="Tesla")
    private <T> boolean hasTeslaCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return true;
        }
        return super.hasCapability(cap, facing);
    }

    @Optional.Method(modid="Tesla")
    private <T> T getTeslaCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return (T)TeslaCapabilities.CAPABILITY_CONSUMER.cast((Object)this.tesla);
        }
        return super.getCapability(cap, facing);
    }

    @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="Tesla")
    private class TeslaConsumer
    implements ITeslaConsumer {
        private TeslaConsumer() {
        }

        @Optional.Method(modid="Tesla")
        public long givePower(long power, boolean simulated) {
            return TileEntityFoundryPowered.this.receiveFoundryEnergy(power * (long)RATIO_TESLA, !simulated, false) / (long)RATIO_TESLA;
        }
    }
}

