/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.heatable.IHeatProvider;
import exter.foundry.tileentity.TileEntityFoundry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public abstract class TileEntityFoundryHeatable
extends TileEntityFoundry {
    public static final int TEMP_MIN = 29000;
    private int heat = 29000;

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("heat")) {
            int temp_max;
            this.heat = compund.func_74762_e("heat");
            if (this.heat < 29000) {
                this.heat = 29000;
            }
            if (this.heat > (temp_max = this.getMaxTemperature())) {
                this.heat = temp_max;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("heat", this.heat);
        return compound;
    }

    public final int getTemperature() {
        return this.heat;
    }

    private final IHeatProvider getHeatProvider() {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
        if (te != null && te.hasCapability(FoundryAPI.capability_heatprovider, EnumFacing.UP)) {
            return (IHeatProvider)te.getCapability(FoundryAPI.capability_heatprovider, EnumFacing.UP);
        }
        return null;
    }

    @Override
    protected void updateServer() {
        IHeatProvider heater;
        int last_heat = this.heat;
        int temp_max = this.getMaxTemperature();
        if (this.canReceiveHeat() && (heater = this.getHeatProvider()) != null) {
            this.heat += heater.provideHeat(TileEntityFoundryHeatable.getMaxHeatRecieve(temp_max, this.getTemperatureLossRate()));
        }
        this.heat -= (this.heat - 29000) / this.getTemperatureLossRate();
        if (this.heat > temp_max) {
            this.heat = temp_max;
        }
        if (this.heat < 29000) {
            this.heat = 29000;
        }
        if (last_heat / 100 != this.heat / 100) {
            this.updateValue("heat", this.heat);
        }
    }

    protected abstract boolean canReceiveHeat();

    protected abstract int getMaxTemperature();

    protected abstract int getTemperatureLossRate();

    public static int getMaxHeatRecieve(int max_heat, int temp_loss_rate) {
        return (max_heat - 29000) / temp_loss_rate;
    }
}

