/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.ModFoundry;
import exter.foundry.network.MessageTileEntitySync;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityFoundry
extends TileEntity
implements ITickable,
IInventory {
    private RedstoneMode mode;
    private List<ContainerSlot> conatiner_slots = new ArrayList<ContainerSlot>();
    private NBTTagCompound update_packet;
    private boolean initialized = false;
    protected boolean last_redstone_signal = false;
    protected boolean redstone_signal = false;
    protected final ItemStack[] inventory;
    private int container_timer = 0;

    protected final void addContainerSlot(ContainerSlot cs) {
        this.conatiner_slots.add(cs);
    }

    protected abstract void updateClient();

    protected abstract void updateServer();

    public abstract FluidTank getTank(int var1);

    public abstract int getTankCount();

    protected abstract void onInitialize();

    public TileEntityFoundry() {
        this.mode = RedstoneMode.RSMODE_IGNORE;
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    @Deprecated
    public final ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public final ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack is = this.inventory[slot];
                this.inventory[slot] = null;
                this.updateInventoryItem(slot);
                this.func_70296_d();
                return is;
            }
            ItemStack is = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.updateInventoryItem(slot);
            this.func_70296_d();
            return is;
        }
        return null;
    }

    @Deprecated
    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack is = this.inventory[slot];
            this.inventory[slot] = null;
            this.updateInventoryItem(slot);
            this.func_70296_d();
            return is;
        }
        return null;
    }

    public final void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.updateInventoryItem(slot);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.initialized = false;
        this.onChunkUnload();
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(null);
    }

    protected final void updateTank(int slot) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update_packet == null) {
            this.update_packet = new NBTTagCompound();
            super.func_189515_b(this.update_packet);
        }
        this.writeTankToNBT(this.update_packet, slot);
    }

    protected final void updateInventoryItem(int slot) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update_packet == null) {
            this.update_packet = new NBTTagCompound();
            super.func_189515_b(this.update_packet);
        }
        this.writeInventoryItemToNBT(this.update_packet, slot);
    }

    protected final void writeTankToNBT(NBTTagCompound compound, int slot) {
        NBTTagCompound tag = new NBTTagCompound();
        this.getTank(slot).writeToNBT(tag);
        compound.func_74782_a("Tank_" + String.valueOf(slot), (NBTBase)tag);
    }

    protected final void writeInventoryItemToNBT(NBTTagCompound compound, int slot) {
        ItemStack is = this.inventory[slot];
        NBTTagCompound tag = new NBTTagCompound();
        if (is != null) {
            tag.func_74757_a("empty", false);
            is.func_77955_b(tag);
        } else {
            tag.func_74757_a("empty", true);
        }
        compound.func_74782_a("Item_" + String.valueOf(slot), (NBTBase)tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound tag;
        int i;
        super.func_145839_a(compound);
        for (i = 0; i < this.getTankCount(); ++i) {
            tag = (NBTTagCompound)compound.func_74781_a("Tank_" + String.valueOf(i));
            if (tag == null) continue;
            FluidTank tank = this.getTank(i);
            tank.setFluid(null);
            tank.readFromNBT(tag);
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            tag = (NBTTagCompound)compound.func_74781_a("Item_" + String.valueOf(i));
            if (tag == null) continue;
            ItemStack stack = null;
            if (!tag.func_74767_n("empty")) {
                stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
            this.inventory[i] = stack;
        }
        if (compound.func_74764_b("rsmode")) {
            this.mode = RedstoneMode.fromID(compound.func_74762_e("rsmode"));
        }
        if (compound.func_74764_b("bucket_timer")) {
            this.container_timer = compound.func_74762_e("container_timer");
        }
    }

    protected void writeTileToNBT(NBTTagCompound compound) {
        super.func_189515_b(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int i;
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        for (i = 0; i < this.getTankCount(); ++i) {
            this.writeTankToNBT(compound, i);
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            this.writeInventoryItemToNBT(compound, i);
        }
        compound.func_74768_a("rsmode", this.mode.id);
        compound.func_74768_a("container_timer", this.container_timer);
        return compound;
    }

    protected final void updateValue(String name, int value) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update_packet == null) {
            this.update_packet = new NBTTagCompound();
            super.func_189515_b(this.update_packet);
        }
        this.update_packet.func_74768_a(name, value);
    }

    protected final void updateValue(String name, long value) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update_packet == null) {
            this.update_packet = new NBTTagCompound();
            super.func_189515_b(this.update_packet);
        }
        this.update_packet.func_74772_a(name, value);
    }

    protected final void updateValue(String name, boolean value) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update_packet == null) {
            this.update_packet = new NBTTagCompound();
            super.func_189515_b(this.update_packet);
        }
        this.update_packet.func_74757_a(name, value);
    }

    protected final void updateNBTTag(String name, NBTTagCompound compound) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update_packet == null) {
            this.update_packet = new NBTTagCompound();
            super.func_189515_b(this.update_packet);
        }
        this.update_packet.func_74782_a(name, (NBTBase)compound);
    }

    protected void sendPacketToNearbyPlayers(NBTTagCompound data) {
        data.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
        ModFoundry.network_channel.sendToAllAround((IMessage)new MessageTileEntitySync(data), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 192.0));
    }

    protected void sendPacketToPlayer(NBTTagCompound data, EntityPlayerMP player) {
        data.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
        ModFoundry.network_channel.sendTo((IMessage)new MessageTileEntitySync(data), player);
    }

    public void func_73660_a() {
        if (!this.initialized && !this.func_145837_r()) {
            this.updateRedstone();
            this.onInitialize();
            this.initialized = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.update_packet == null) {
                this.update_packet = new NBTTagCompound();
                super.func_189515_b(this.update_packet);
            }
            for (ContainerSlot cs : this.conatiner_slots) {
                cs.update();
            }
            if (this.container_timer > 0) {
                --this.container_timer;
            }
            this.updateServer();
            if (this.update_packet != null) {
                this.sendPacketToNearbyPlayers(this.update_packet);
            }
            this.update_packet = null;
        } else {
            this.updateClient();
        }
        this.last_redstone_signal = this.redstone_signal;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b.field_72995_K) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    public void updateRedstone() {
        this.redstone_signal = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : player.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public RedstoneMode getRedstoneMode() {
        return this.mode;
    }

    public void setRedstoneMode(RedstoneMode new_mode) {
        if (this.mode != new_mode) {
            this.mode = new_mode;
            if (this.field_145850_b.field_72995_K) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("rsmode", this.mode.id);
                this.sendToServer(tag);
            }
        }
    }

    protected void sendToServer(NBTTagCompound tag) {
        if (this.field_145850_b.field_72995_K) {
            super.func_189515_b(tag);
            tag.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
            ModFoundry.network_channel.sendToServer((IMessage)new MessageTileEntitySync(tag));
        }
    }

    public void func_174889_b(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && player instanceof EntityPlayerMP) {
            NBTTagCompound tag = this.func_189515_b(null);
            this.sendPacketToPlayer(tag, (EntityPlayerMP)player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && player instanceof EntityPlayerMP) {
            NBTTagCompound tag = new NBTTagCompound();
            super.func_189515_b(tag);
            tag.func_74768_a("rsmode", this.mode.id);
            this.sendPacketToPlayer(tag, (EntityPlayerMP)player);
        }
    }

    protected final FluidStack drainTank(int slot, FluidStack resource, boolean doDrain) {
        FluidTank tank = this.getTank(slot);
        if (resource.isFluidEqual(tank.getFluid())) {
            FluidStack drained = tank.drain(resource.amount, doDrain);
            if (doDrain && drained != null && drained.amount > 0) {
                this.updateTank(slot);
                this.func_70296_d();
            }
            return drained;
        }
        return null;
    }

    protected final FluidStack drainTank(int slot, int maxDrain, boolean doDrain) {
        FluidTank tank = this.getTank(slot);
        FluidStack drained = tank.drain(maxDrain, doDrain);
        if (doDrain && drained != null && drained.amount > 0) {
            this.updateTank(slot);
            this.func_70296_d();
        }
        return drained;
    }

    protected final int fillTank(int slot, FluidStack resource, boolean doFill) {
        FluidTank tank = this.getTank(slot);
        int filled = tank.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.updateTank(slot);
            this.func_70296_d();
        }
        return filled;
    }

    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return null;
    }

    protected IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getFluidHandler(facing) != null;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandler(facing) != null;
        }
        return super.hasCapability(cap, facing);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler fluid_handler = this.getFluidHandler(facing);
            if (fluid_handler != null) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidHandler(facing));
            }
            return (T)super.getCapability(cap, facing);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler item_handler = this.getItemHandler(facing);
            if (item_handler != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler(facing));
            }
            return (T)super.getCapability(cap, facing);
        }
        return (T)super.getCapability(cap, facing);
    }

    @Deprecated
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler == null) {
            return 0;
        }
        return handler.fill(resource, doFill);
    }

    @Deprecated
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler == null) {
            return null;
        }
        return handler.drain(resource, doDrain);
    }

    @Deprecated
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler == null) {
            return null;
        }
        return handler.drain(maxDrain, doDrain);
    }

    @Deprecated
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.getFluidHandler(from) != null;
    }

    @Deprecated
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.getFluidHandler(from) != null;
    }

    @Deprecated
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler == null) {
            return null;
        }
        IFluidTankProperties[] props = handler.getTankProperties();
        FluidTankInfo[] info = new FluidTankInfo[props.length];
        for (int i = 0; i < info.length; ++i) {
            info[i] = new FluidTankInfo(props[i].getContents(), props[i].getCapacity());
        }
        return info;
    }

    public class ContainerSlot {
        public final boolean fill;
        public final int tank_slot;
        public final int slot;
        public final Fluid fluid;

        public ContainerSlot(int container_tank, int container_slot, boolean container_fill) {
            this(container_tank, container_slot, container_fill, null);
        }

        public ContainerSlot(int container_tank, int container_slot, boolean container_fill, Fluid container_fluid) {
            this.tank_slot = container_tank;
            this.slot = container_slot;
            this.fill = container_fill;
            this.fluid = container_fluid;
        }

        public void update() {
            if (TileEntityFoundry.this.container_timer > 0) {
                return;
            }
            ItemStack stack = TileEntityFoundry.this.func_70301_a(this.slot);
            if (stack == null || stack.field_77994_a > 1) {
                return;
            }
            FluidTank tank = TileEntityFoundry.this.getTank(this.tank_slot);
            if (this.fill) {
                if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                    IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    FluidStack drained = tank.drain(1000, false);
                    if (drained == null || drained.amount == 0 || this.fluid != null && drained.getFluid() != this.fluid) {
                        return;
                    }
                    int filled = handler.fill(drained, false);
                    if (filled == 0) {
                        return;
                    }
                    drained.amount = filled;
                    drained = tank.drain(filled, true);
                    handler.fill(drained, true);
                    TileEntityFoundry.this.updateTank(this.tank_slot);
                    TileEntityFoundry.this.updateInventoryItem(this.slot);
                    TileEntityFoundry.this.container_timer = filled / 25;
                }
            } else if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                FluidStack drained = handler.drain(1000, false);
                if (drained == null || drained.amount == 0 || this.fluid != null && drained.getFluid() != this.fluid) {
                    return;
                }
                int filled = tank.fill(drained, false);
                if (filled == 0) {
                    return;
                }
                drained.amount = filled;
                drained = handler.drain(filled, true);
                tank.fill(drained, true);
                TileEntityFoundry.this.container_timer = filled / 25;
                TileEntityFoundry.this.updateTank(this.tank_slot);
                TileEntityFoundry.this.updateInventoryItem(this.slot);
            }
        }
    }

    public class ItemHandler
    implements IItemHandler {
        protected final int slots;
        protected final ImmutableSet<Integer> insert_slots;
        protected final ImmutableSet<Integer> extract_slots;

        protected boolean canInsert(int slot, ItemStack stack) {
            return TileEntityFoundry.this.func_94041_b(slot, stack);
        }

        protected boolean canExtract(int slot) {
            return true;
        }

        public ItemHandler(int slots, Set<Integer> insert_slots, Set<Integer> extract_slots) {
            this.slots = slots;
            this.insert_slots = ImmutableSet.copyOf(insert_slots);
            this.extract_slots = ImmutableSet.copyOf(extract_slots);
        }

        public final int getSlots() {
            return this.slots;
        }

        public final ItemStack getStackInSlot(int slot) {
            return TileEntityFoundry.this.inventory[slot];
        }

        public final ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.insert_slots.contains((Object)slot) || !this.canInsert(slot, stack)) {
                return stack;
            }
            ItemStack is = TileEntityFoundry.this.inventory[slot];
            if (is == null) {
                TileEntityFoundry.this.inventory[slot] = stack;
                TileEntityFoundry.this.updateInventoryItem(slot);
                TileEntityFoundry.this.func_70296_d();
                return null;
            }
            if (is.func_77969_a(stack) && ItemStack.func_77989_b((ItemStack)is, (ItemStack)stack)) {
                if (stack.field_77994_a + is.field_77994_a > is.func_77976_d()) {
                    stack = stack.func_77946_l();
                    stack.field_77994_a = is.func_77976_d() - is.field_77994_a;
                    is.field_77994_a = is.func_77976_d();
                    TileEntityFoundry.this.updateInventoryItem(slot);
                    TileEntityFoundry.this.func_70296_d();
                    stack = null;
                } else {
                    is.field_77994_a += stack.field_77994_a;
                }
                TileEntityFoundry.this.updateInventoryItem(slot);
                TileEntityFoundry.this.func_70296_d();
                return stack;
            }
            return stack;
        }

        public final ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.extract_slots.contains((Object)slot) || !this.canExtract(slot)) {
                return null;
            }
            ItemStack is = TileEntityFoundry.this.inventory[slot];
            if (is == null) {
                return null;
            }
            if (amount > is.field_77994_a) {
                amount = is.field_77994_a;
            }
            if (!simulate) {
                is.field_77994_a -= amount;
                if (is.field_77994_a == 0) {
                    TileEntityFoundry.this.inventory[slot] = null;
                }
                TileEntityFoundry.this.updateInventoryItem(slot);
                TileEntityFoundry.this.func_70296_d();
            }
            is = is.func_77946_l();
            is.field_77994_a = amount;
            return is;
        }
    }

    protected class FluidHandler
    implements IFluidHandler {
        private int fill_tank;
        private int drain_tank;
        private IFluidTankProperties[] props;

        public FluidHandler(int fill_tank, int drain_tank) {
            this.fill_tank = fill_tank;
            this.drain_tank = drain_tank;
            this.props = new IFluidTankProperties[TileEntityFoundry.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityFoundry.this.getTank(i));
            }
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.fill_tank < 0) {
                return 0;
            }
            return TileEntityFoundry.this.fillTank(this.fill_tank, resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.drain_tank < 0) {
                return null;
            }
            return TileEntityFoundry.this.drainTank(this.drain_tank, resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.drain_tank < 0) {
                return null;
            }
            return TileEntityFoundry.this.drainTank(this.drain_tank, maxDrain, doDrain);
        }
    }

    public static enum RedstoneMode {
        RSMODE_IGNORE(0),
        RSMODE_ON(1),
        RSMODE_OFF(2),
        RSMODE_PULSE(3);

        public final int id;

        private RedstoneMode(int num) {
            this.id = num;
        }

        public static RedstoneMode fromID(int num) {
            for (RedstoneMode m : RedstoneMode.values()) {
                if (m.id != num) continue;
                return m;
            }
            return RSMODE_IGNORE;
        }
    }
}

