/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.block.BlockCokeOven;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemComponent;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityFoundryHeatable;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCokeOven
extends TileEntityFoundryHeatable
implements ISidedInventory {
    public static final int BAKE_TIME = 60000000;
    public static final int BAKE_TEMP = 160000;
    public static final int INVENTORY_INPUT = 0;
    public static final int INVENTORY_OUTPUT = 1;
    @Deprecated
    private static final int[] SLOTS = new int[]{0, 1};
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of((Object)1);
    private TileEntityFoundry.ItemHandler item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
    private int progress = 0;

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("progress")) {
            this.progress = compund.func_74762_e("progress");
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((BlockCokeOven)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.progress > 0);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("progress", this.progress);
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int func_70302_i_() {
        return 2;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0;
    }

    @Deprecated
    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    @Deprecated
    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(i, itemstack);
    }

    @Deprecated
    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing side) {
        return i == 1;
    }

    @Override
    protected void updateClient() {
    }

    private boolean canBake() {
        if (this.getTemperature() <= 160000) {
            return false;
        }
        ItemStack input = this.inventory[0];
        ItemStack output = this.inventory[1];
        if (input == null || input.func_77973_b() != Items.field_151044_h || input.func_77960_j() != 0) {
            return false;
        }
        return output == null || output.func_77973_b() == FoundryItems.item_component || output.func_77960_j() == ItemComponent.SubItem.COAL_COKE.id || output.field_77994_a != output.func_77976_d();
    }

    private void doBakingProgress() {
        if (!this.canBake()) {
            this.progress = 0;
            return;
        }
        int heat = this.getTemperature();
        int increment = heat - 160000;
        this.progress += increment;
        if (this.progress >= 60000000) {
            if (this.inventory[1] == null) {
                this.inventory[1] = FoundryItems.component(ItemComponent.SubItem.COAL_COKE);
            } else {
                ++this.inventory[1].field_77994_a;
            }
            this.progress = 0;
            this.func_70298_a(0, 1);
            this.updateInventoryItem(1);
            this.func_70296_d();
        }
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        int last_progress = this.progress;
        this.doBakingProgress();
        if (last_progress != this.progress) {
            if (last_progress * this.progress == 0) {
                ((BlockCokeOven)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.progress > 0);
            }
            this.updateValue("progress", this.progress);
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    public int getMaxTemperature() {
        return 220000;
    }

    @Override
    protected int getTemperatureLossRate() {
        return 750;
    }

    @Override
    protected boolean canReceiveHeat() {
        boolean active = true;
        switch (this.getRedstoneMode()) {
            case RSMODE_OFF: {
                if (!this.redstone_signal) break;
                active = false;
                break;
            }
            case RSMODE_ON: {
                if (this.redstone_signal) break;
                active = false;
                break;
            }
        }
        return active;
    }
}

