/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import java.util.Set;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityCastingTableBase
extends TileEntityFoundry
implements ISidedInventory,
net.minecraftforge.fluids.IFluidHandler {
    public static final int CAST_TIME = 300;
    private FluidTank tank = new FluidTank(this.getDefaultCapacity());
    private IFluidHandler fluid_handler = new FluidHandler();
    private ICastingTableRecipe recipe = null;
    private int progress = 0;
    private ItemHandlerTable item_handler = new ItemHandlerTable(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of();
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of((Object)0);
    private static final int[] EXTRACT_SLOTS = new int[]{0};

    @Override
    protected IItemHandler getItemHandler(EnumFacing facing) {
        return this.item_handler;
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    protected final void onInitialize() {
    }

    @Override
    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Tank_0")) {
            this.setRecipe(this.tank.getFluid());
        }
        if (compound.func_74764_b("progress")) {
            this.progress = compound.func_74762_e("progress");
        }
        if (this.field_145850_b.field_72995_K && compound.func_74764_b("tank_capacity")) {
            this.tank.setCapacity(compound.func_74762_e("tank_capacity"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("progress", this.progress);
        return compound;
    }

    public final int func_70302_i_() {
        return 1;
    }

    public final int getProgress() {
        return this.progress;
    }

    @Deprecated
    public final boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }

    @Deprecated
    public final int[] func_180463_a(EnumFacing side) {
        return EXTRACT_SLOTS;
    }

    @Deprecated
    public final boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        return false;
    }

    @Deprecated
    public final boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        return this.progress == 0;
    }

    @Override
    @Deprecated
    public final ItemStack func_70304_b(int slot) {
        if (this.progress > 0) {
            return null;
        }
        return super.func_70304_b(slot);
    }

    @Override
    protected void updateClient() {
    }

    private void setRecipe(FluidStack fluid) {
        if (fluid == null || fluid.amount == 0) {
            this.recipe = null;
            this.tank.setCapacity(this.getDefaultCapacity());
            this.updateValue("tank_capacity", this.tank.getCapacity());
            return;
        }
        this.recipe = CastingTableRecipeManager.instance.findRecipe(fluid, this.getTableType());
        if (this.recipe != null) {
            if (this.recipe.getOutput() == null) {
                this.recipe = null;
                this.tank.setCapacity(this.getDefaultCapacity());
                this.updateValue("tank_capacity", this.tank.getCapacity());
                return;
            }
            this.tank.setCapacity(this.recipe.getInput().amount);
            this.updateValue("tank_capacity", this.tank.getCapacity());
        }
    }

    @Override
    protected final void updateServer() {
        int last_progress = this.progress;
        if (this.progress > 0) {
            if (--this.progress == 0) {
                this.tank.setFluid(null);
                this.updateTank(0);
                this.setRecipe(null);
            }
        } else if (this.inventory[0] == null && this.recipe != null && this.tank.getFluid().amount == this.recipe.getInput().amount) {
            this.func_70299_a(0, this.recipe.getOutput());
            this.progress = 300;
        }
        if (last_progress != this.progress) {
            this.updateValue("progress", this.progress);
        }
    }

    @Override
    public final FluidTank getTank(int slot) {
        return this.tank;
    }

    @Override
    public final int getTankCount() {
        return 1;
    }

    public abstract int getDefaultCapacity();

    public abstract ICastingTableRecipe.TableType getTableType();

    private class ItemHandlerTable
    extends TileEntityFoundry.ItemHandler {
        public ItemHandlerTable(int slots, Set<Integer> insert_slots, Set<Integer> extract_slots) {
            super(slots, insert_slots, extract_slots);
        }

        @Override
        protected boolean canExtract(int slot) {
            return TileEntityCastingTableBase.this.progress == 0;
        }
    }

    protected class FluidHandler
    implements IFluidHandler {
        private IFluidTankProperties[] props;

        public FluidHandler() {
            this.props = new IFluidTankProperties[TileEntityCastingTableBase.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityCastingTableBase.this.getTank(i));
            }
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (TileEntityCastingTableBase.this.inventory[0] != null) {
                return 0;
            }
            if (doFill && (TileEntityCastingTableBase.this.tank.getFluid() == null || ((TileEntityCastingTableBase)TileEntityCastingTableBase.this).tank.getFluid().amount == 0)) {
                TileEntityCastingTableBase.this.setRecipe(resource);
            }
            return TileEntityCastingTableBase.this.fillTank(0, resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (TileEntityCastingTableBase.this.progress > 0) {
                return null;
            }
            FluidStack result = TileEntityCastingTableBase.this.drainTank(0, resource, doDrain);
            if (doDrain) {
                TileEntityCastingTableBase.this.setRecipe(TileEntityCastingTableBase.this.tank.getFluid());
            }
            return result;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (TileEntityCastingTableBase.this.progress > 0) {
                return null;
            }
            FluidStack result = TileEntityCastingTableBase.this.drainTank(0, maxDrain, doDrain);
            if (doDrain) {
                TileEntityCastingTableBase.this.setRecipe(TileEntityCastingTableBase.this.tank.getFluid());
            }
            return result;
        }
    }
}

