/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.FoundryAPI;
import exter.foundry.api.heatable.IHeatProvider;
import exter.foundry.api.recipe.IBurnerHeaterFuel;
import exter.foundry.block.BlockBurnerHeater;
import exter.foundry.recipes.manager.BurnerHeaterFuelManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityFoundryHeatable;
import exter.foundry.tileentity.itemhandler.ItemHandlerFuel;
import exter.foundry.util.FoundryMiscUtils;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.item.IExoflameHeatable;

@Optional.Interface(iface="vazkii.botania.api.item.IExoflameHeatable", modid="Botania")
public class TileEntityBurnerHeater
extends TileEntityFoundry
implements ISidedInventory,
IExoflameHeatable {
    private int burn_time = 0;
    private int item_burn_time = 0;
    private int heat_provide = DEFAULT_HEAT_PROVIDE;
    private boolean update_burn_times = false;
    private HeatProvider heat_provider = new HeatProvider();
    private ItemHandlerFuel item_handler = new ItemHandlerFuel(this, this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT, IH_SLOTS_FUEL);
    private static int DEFAULT_HEAT_PROVIDE = TileEntityFoundryHeatable.getMaxHeatRecieve(170000, 750);
    @Deprecated
    private static final int[] SLOTS = new int[]{0, 1, 2, 3};
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of();
    private static final Set<Integer> IH_SLOTS_FUEL = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3);

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("BurnTime")) {
            this.burn_time = tag.func_74762_e("BurnTime");
        }
        if (tag.func_74764_b("ItemBurnTime")) {
            this.item_burn_time = tag.func_74762_e("ItemBurnTime");
        }
        if (tag.func_74764_b("HeatProvide")) {
            this.heat_provide = tag.func_74762_e("HeatProvide");
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((BlockBurnerHeater)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burn_time);
        compound.func_74768_a("ItemBurnTime", this.item_burn_time);
        compound.func_74768_a("HeatProvide", this.heat_provide);
        return compound;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burn_time > 0;
    }

    @Override
    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : par1EntityPlayer.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int par1, ItemStack par2ItemStack, EnumFacing side) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return true;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        int last_burn_time = this.burn_time;
        int last_item_burn_time = this.item_burn_time;
        if (this.burn_time < 10) {
            for (int i = 0; i < 4; ++i) {
                ItemStack item = this.inventory[i];
                if (item == null) continue;
                int burn = 0;
                IBurnerHeaterFuel fuel = BurnerHeaterFuelManager.instance.getFuel(item);
                if (fuel != null) {
                    burn = fuel.getBurnTime() * 10;
                    this.heat_provide = fuel.getHeat();
                } else {
                    burn = TileEntityFurnace.func_145952_a((ItemStack)item) * 10;
                    this.heat_provide = DEFAULT_HEAT_PROVIDE;
                }
                if (burn <= 0) continue;
                this.burn_time += burn;
                this.item_burn_time = this.burn_time;
                if (--item.field_77994_a == 0) {
                    this.inventory[i] = item.func_77973_b().getContainerItem(item);
                }
                this.updateInventoryItem(i);
                break;
            }
        }
        if (last_burn_time != this.burn_time || this.update_burn_times) {
            if (last_burn_time * this.burn_time == 0) {
                ((BlockBurnerHeater)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
            }
            this.updateValue("BurnTime", this.burn_time);
        }
        if (last_item_burn_time != this.item_burn_time || this.update_burn_times) {
            this.updateValue("ItemBurnTime", this.item_burn_time);
        }
        this.update_burn_times = false;
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    @Override
    protected void onInitialize() {
    }

    public int getBurningTime() {
        return this.burn_time;
    }

    public int getItemBurnTime() {
        return this.item_burn_time;
    }

    @Override
    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return super.hasCapability(cap, facing) || cap == FoundryAPI.capability_heatprovider && facing == EnumFacing.UP;
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == FoundryAPI.capability_heatprovider && facing == EnumFacing.UP) {
            return (T)FoundryAPI.capability_heatprovider.cast((Object)this.heat_provider);
        }
        return super.getCapability(cap, facing);
    }

    @Optional.Method(modid="Botania")
    public boolean canSmelt() {
        return true;
    }

    @Optional.Method(modid="Botania")
    public int getBurnTime() {
        return this.burn_time <= 1 ? 0 : this.burn_time - 1;
    }

    @Optional.Method(modid="Botania")
    public void boostBurnTime() {
        if (!this.field_145850_b.field_72995_K) {
            this.heat_provide = DEFAULT_HEAT_PROVIDE;
            this.burn_time = 2000;
            this.item_burn_time = 1999;
            this.update_burn_times = true;
            this.func_70296_d();
        }
    }

    @Optional.Method(modid="Botania")
    public void boostCookTime() {
    }

    private class HeatProvider
    implements IHeatProvider {
        private HeatProvider() {
        }

        @Override
        public int provideHeat(int max_heat) {
            if (TileEntityBurnerHeater.this.burn_time > 0 && max_heat > 0) {
                if (max_heat > 0) {
                    if (max_heat > TileEntityBurnerHeater.this.heat_provide) {
                        max_heat = TileEntityBurnerHeater.this.heat_provide;
                    }
                    int last_burn_time = TileEntityBurnerHeater.this.burn_time;
                    TileEntityBurnerHeater.this.burn_time = TileEntityBurnerHeater.this.burn_time - FoundryMiscUtils.divCeil(max_heat * 10, TileEntityBurnerHeater.this.heat_provide);
                    if (TileEntityBurnerHeater.this.burn_time < 0) {
                        TileEntityBurnerHeater.this.burn_time = 0;
                    }
                    if (last_burn_time != TileEntityBurnerHeater.this.burn_time || TileEntityBurnerHeater.this.update_burn_times) {
                        if (last_burn_time * TileEntityBurnerHeater.this.burn_time == 0) {
                            ((BlockBurnerHeater)TileEntityBurnerHeater.this.func_145838_q()).setMachineState(TileEntityBurnerHeater.this.field_145850_b, TileEntityBurnerHeater.this.func_174877_v(), TileEntityBurnerHeater.this.field_145850_b.func_180495_p(TileEntityBurnerHeater.this.func_174877_v()), TileEntityBurnerHeater.this.burn_time > 0);
                        }
                        TileEntityBurnerHeater.this.updateValue("BurnTime", TileEntityBurnerHeater.this.burn_time);
                    }
                }
                return max_heat;
            }
            return 0;
        }
    }
}

