/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.api.recipe.IAlloyMixerRecipe;
import exter.foundry.recipes.manager.AlloyMixerRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityFoundryPowered;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityAlloyMixer
extends TileEntityFoundryPowered
implements net.minecraftforge.fluids.IFluidHandler {
    public static final int INVENTORY_CONTAINER_INPUT_0_DRAIN = 0;
    public static final int INVENTORY_CONTAINER_INPUT_0_FILL = 1;
    public static final int INVENTORY_CONTAINER_INPUT_1_DRAIN = 2;
    public static final int INVENTORY_CONTAINER_INPUT_1_FILL = 3;
    public static final int INVENTORY_CONTAINER_INPUT_2_DRAIN = 4;
    public static final int INVENTORY_CONTAINER_INPUT_2_FILL = 5;
    public static final int INVENTORY_CONTAINER_INPUT_3_DRAIN = 6;
    public static final int INVENTORY_CONTAINER_INPUT_3_FILL = 7;
    public static final int INVENTORY_CONTAINER_OUTPUT_DRAIN = 8;
    public static final int INVENTORY_CONTAINER_OUTPUT_FILL = 9;
    public static final int TANK_INPUT_0 = 0;
    public static final int TANK_INPUT_1 = 1;
    public static final int TANK_INPUT_2 = 2;
    public static final int TANK_INPUT_3 = 3;
    public static final int TANK_OUTPUT = 4;
    private FluidTank[] tanks;
    private IFluidHandler fluid_handler;
    private int[] recipe_order = new int[4];
    private FluidStack[] input_tank_fluids = new FluidStack[4];

    public TileEntityAlloyMixer() {
        this.tanks = new FluidTank[5];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(2000);
        }
        this.fluid_handler = new FluidHandler();
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 0, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 1, true));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(1, 2, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(1, 3, true));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(2, 4, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(2, 5, true));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(3, 6, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(3, 7, true));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(4, 8, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(4, 9, true));
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    public int func_70302_i_() {
        return 10;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    protected void updateClient() {
    }

    private void mixAlloy() {
        int i;
        if (this.getStoredFoundryEnergy() < 10L) {
            return;
        }
        boolean do_mix = false;
        switch (this.getRedstoneMode()) {
            case RSMODE_IGNORE: {
                do_mix = true;
                break;
            }
            case RSMODE_OFF: {
                if (this.redstone_signal || this.last_redstone_signal) break;
                do_mix = true;
                break;
            }
            case RSMODE_ON: {
                if (!this.redstone_signal || !this.last_redstone_signal) break;
                do_mix = true;
                break;
            }
        }
        if (!do_mix) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            this.input_tank_fluids[i] = this.tanks[i].getFluid();
        }
        IAlloyMixerRecipe recipe = AlloyMixerRecipeManager.instance.findRecipe(this.input_tank_fluids, this.recipe_order);
        if (recipe == null) {
            return;
        }
        int energy_used = 0;
        block6: while (energy_used < 2500) {
            if (!recipe.matchesRecipe(this.input_tank_fluids, this.recipe_order)) {
                return;
            }
            FluidStack output = recipe.getOutput();
            if (this.tanks[4].fill(output, false) < output.amount) {
                return;
            }
            int required_energy = 10 * output.amount;
            if (this.useFoundryEnergy(required_energy, false) < (long)required_energy) {
                return;
            }
            this.useFoundryEnergy(required_energy, true);
            energy_used += required_energy;
            this.tanks[4].fill(output, true);
            this.updateTank(4);
            List<FluidStack> inputs = recipe.getInputs();
            i = 0;
            while (true) {
                if (i >= inputs.size()) continue block6;
                this.tanks[this.recipe_order[i]].drain(inputs.get((int)i).amount, true);
                this.updateTank(this.recipe_order[i]);
                ++i;
            }
            break;
        }
        return;
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        if (this.tanks[4].getFluidAmount() < this.tanks[4].getCapacity() && (this.tanks[0].getFluidAmount() > 0 || this.tanks[1].getFluidAmount() > 0 || this.tanks[2].getFluidAmount() > 0 || this.tanks[3].getFluidAmount() > 0)) {
            this.mixAlloy();
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        return this.tanks[slot];
    }

    @Override
    public int getTankCount() {
        return 5;
    }

    @Override
    public long getFoundryEnergyCapacity() {
        return 3000L;
    }

    protected class FluidHandler
    implements IFluidHandler {
        private IFluidTankProperties[] props;

        public FluidHandler() {
            this.props = new IFluidTankProperties[TileEntityAlloyMixer.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityAlloyMixer.this.getTank(i));
            }
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int empty = -1;
            int partial = -1;
            for (int i = 0; i < 4; ++i) {
                FluidTank ft = TileEntityAlloyMixer.this.tanks[i];
                if (ft.getFluidAmount() > 0) {
                    if (!ft.getFluid().isFluidEqual(resource)) continue;
                    if (ft.getFluidAmount() < ft.getCapacity()) {
                        partial = i;
                        continue;
                    }
                    return 0;
                }
                empty = i;
            }
            if (partial != -1) {
                return TileEntityAlloyMixer.this.fillTank(partial, resource, doFill);
            }
            if (empty != -1) {
                return TileEntityAlloyMixer.this.fillTank(empty, resource, doFill);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityAlloyMixer.this.drainTank(4, resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityAlloyMixer.this.drainTank(4, maxDrain, doDrain);
        }
    }
}

