/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.recipe.IAlloyFurnaceRecipe;
import exter.foundry.block.BlockAlloyFurnace;
import exter.foundry.recipes.manager.AlloyFurnaceRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.itemhandler.ItemHandlerFuel;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.item.IExoflameHeatable;

@Optional.Interface(iface="vazkii.botania.api.item.IExoflameHeatable", modid="Botania")
public class TileEntityAlloyFurnace
extends TileEntityFoundry
implements ISidedInventory,
IExoflameHeatable {
    public static final int SLOT_INPUT_A = 0;
    public static final int SLOT_INPUT_B = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_FUEL = 3;
    public int burn_time = 0;
    public int item_burn_time = 0;
    public int progress = 0;
    private boolean update_burn_times = false;
    @Deprecated
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    @Deprecated
    private static final int[] SLOTS_BOTTOM = new int[]{2, 3};
    @Deprecated
    private static final int[] SLOTS_SIDES = new int[]{3};
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0, (Object)1);
    private static final Set<Integer> IH_SLOTS_INPUT_FUEL = ImmutableSet.of((Object)0, (Object)1, (Object)3);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of((Object)2);
    private static final Set<Integer> IH_SLOTS_OUTPUT_FUEL = ImmutableSet.of((Object)2, (Object)3);
    private static final Set<Integer> IH_SLOTS_FUEL = ImmutableSet.of((Object)3);
    private TileEntityFoundry.ItemHandler item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
    private ItemHandlerFuel item_handler_fuel = new ItemHandlerFuel(this, this.func_70302_i_(), IH_SLOTS_INPUT_FUEL, IH_SLOTS_OUTPUT_FUEL, IH_SLOTS_FUEL);

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        switch (side) {
            case UP: {
                return this.item_handler;
            }
        }
        return this.item_handler_fuel;
    }

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("BurnTime")) {
            this.burn_time = tag.func_74762_e("BurnTime");
        }
        if (tag.func_74764_b("CookTime")) {
            this.progress = tag.func_74762_e("CookTime");
        }
        if (tag.func_74764_b("ItemBurnTime")) {
            this.item_burn_time = tag.func_74762_e("ItemBurnTime");
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((BlockAlloyFurnace)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burn_time);
        compound.func_74768_a("CookTime", this.progress);
        compound.func_74768_a("ItemBurnTime", this.item_burn_time);
        return compound;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burn_time > 0;
    }

    @Override
    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : par1EntityPlayer.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 2: {
                return false;
            }
            case 3: {
                return TileEntityFurnace.func_145954_b((ItemStack)stack);
            }
        }
        return true;
    }

    @Deprecated
    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return SLOTS_BOTTOM;
            }
            case UP: {
                return SLOTS_TOP;
            }
        }
        return SLOTS_SIDES;
    }

    @Deprecated
    public boolean func_180462_a(int par1, ItemStack par2ItemStack, EnumFacing side) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    @Deprecated
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return side != EnumFacing.UP || slot != 0 || slot != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }

    @Override
    protected void updateClient() {
    }

    private boolean canOutput(IAlloyFurnaceRecipe recipe) {
        ItemStack output = recipe.getOutput();
        ItemStack inv_output = this.inventory[2];
        return inv_output == null || inv_output.func_77969_a(output) && inv_output.field_77994_a - output.field_77994_a <= inv_output.func_77976_d();
    }

    private void doSmelt(IAlloyFurnaceRecipe recipe, boolean reversed) {
        ItemStack output = recipe.getOutput();
        if (!this.canOutput(recipe)) {
            this.progress = 0;
            return;
        }
        if (++this.progress == 400) {
            this.progress = 0;
            if (reversed) {
                this.func_70298_a(1, recipe.getInputA().getAmount());
                this.func_70298_a(0, recipe.getInputB().getAmount());
            } else {
                this.func_70298_a(0, recipe.getInputA().getAmount());
                this.func_70298_a(1, recipe.getInputB().getAmount());
            }
            if (this.inventory[2] == null) {
                this.inventory[2] = output.func_77946_l();
            } else {
                this.inventory[2].field_77994_a += output.field_77994_a;
            }
            this.updateInventoryItem(2);
            this.func_70296_d();
        }
    }

    @Override
    protected void updateServer() {
        int last_burn_time = this.burn_time;
        int last_progress = this.progress;
        int last_item_burn_time = this.item_burn_time;
        if (this.burn_time > 0) {
            --this.burn_time;
        }
        boolean reversed = false;
        IAlloyFurnaceRecipe recipe = null;
        if (this.inventory[0] != null && this.inventory[1] != null && (recipe = AlloyFurnaceRecipeManager.instance.findRecipe(this.inventory[0], this.inventory[1])) == null && (recipe = AlloyFurnaceRecipeManager.instance.findRecipe(this.inventory[1], this.inventory[0])) != null) {
            reversed = true;
        }
        if (this.burn_time == 0 && recipe != null && this.canOutput(recipe)) {
            this.item_burn_time = this.burn_time = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[3]);
            if (this.burn_time > 0 && this.inventory[3] != null) {
                if (--this.inventory[3].field_77994_a == 0) {
                    this.inventory[3] = this.inventory[3].func_77973_b().getContainerItem(this.inventory[3]);
                }
                this.updateInventoryItem(3);
            }
        }
        if (this.burn_time > 0) {
            if (recipe != null) {
                this.doSmelt(recipe, reversed);
            } else {
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
        if (last_burn_time != this.burn_time || this.update_burn_times) {
            if (last_burn_time * this.burn_time == 0) {
                ((BlockAlloyFurnace)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
            }
            this.updateValue("BurnTime", this.burn_time);
        }
        if (last_item_burn_time != this.item_burn_time || this.update_burn_times) {
            this.updateValue("ItemBurnTime", this.item_burn_time);
        }
        this.update_burn_times = false;
        if (last_progress != this.progress) {
            this.updateValue("CookTime", this.progress);
        }
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    @Override
    protected void onInitialize() {
    }

    @Optional.Method(modid="Botania")
    public boolean canSmelt() {
        if (this.inventory[0] != null && this.inventory[1] != null) {
            IAlloyFurnaceRecipe recipe = AlloyFurnaceRecipeManager.instance.findRecipe(this.inventory[0], this.inventory[1]);
            if (recipe == null) {
                recipe = AlloyFurnaceRecipeManager.instance.findRecipe(this.inventory[1], this.inventory[0]);
            }
            if (recipe == null) {
                return false;
            }
            ItemStack output = recipe.getOutput();
            ItemStack inv_output = this.inventory[2];
            return inv_output == null || inv_output.func_77969_a(output) && inv_output.field_77994_a - output.field_77994_a <= inv_output.func_77976_d();
        }
        return false;
    }

    @Optional.Method(modid="Botania")
    public int getBurnTime() {
        return this.burn_time <= 1 ? 0 : this.burn_time - 1;
    }

    @Optional.Method(modid="Botania")
    public void boostBurnTime() {
        if (!this.field_145850_b.field_72995_K) {
            this.burn_time = 200;
            this.item_burn_time = 199;
            this.update_burn_times = true;
            this.func_70296_d();
        }
    }

    @Optional.Method(modid="Botania")
    public void boostCookTime() {
    }
}

