/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.api.recipe.manager.IMeltingRecipeManager;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.recipes.MeltingRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MeltingRecipeManager
implements IMeltingRecipeManager {
    public List<IMeltingRecipe> recipes = new ArrayList<IMeltingRecipe>();
    public static final MeltingRecipeManager instance = new MeltingRecipeManager();

    private MeltingRecipeManager() {
    }

    @Override
    public IMeltingRecipe findRecipe(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (IMeltingRecipe r : this.recipes) {
            if (!r.matchesRecipe(item)) continue;
            return r;
        }
        return null;
    }

    @Override
    public void addRecipe(IItemMatcher solid, FluidStack fluid_stack) {
        this.addRecipe(solid, fluid_stack, fluid_stack.getFluid().getTemperature(), 100);
    }

    @Override
    public void addRecipe(IItemMatcher solid, FluidStack fluid_stack, int melting_point) {
        this.addRecipe(solid, fluid_stack, melting_point, 100);
    }

    @Override
    public void addRecipe(IItemMatcher solid, FluidStack fluid_stack, int melting_point, int melting_speed) {
        this.recipes.add(new MeltingRecipe(solid, fluid_stack, melting_point, melting_speed));
    }

    @Override
    public List<IMeltingRecipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Override
    public void removeRecipe(IMeltingRecipe recipe) {
        this.recipes.remove(recipe);
    }
}

