/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.api.recipe.manager.ICastingTableRecipeManager;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.recipes.CastingTableRecipe;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;

public class CastingTableRecipeManager
implements ICastingTableRecipeManager {
    public Map<ICastingTableRecipe.TableType, Map<String, ICastingTableRecipe>> recipes = new EnumMap<ICastingTableRecipe.TableType, Map<String, ICastingTableRecipe>>(ICastingTableRecipe.TableType.class);
    public static final CastingTableRecipeManager instance = new CastingTableRecipeManager();

    private CastingTableRecipeManager() {
        for (ICastingTableRecipe.TableType type : ICastingTableRecipe.TableType.values()) {
            this.recipes.put(type, new HashMap());
        }
    }

    @Override
    public void addRecipe(IItemMatcher result, FluidStack fluid, ICastingTableRecipe.TableType type) {
        CastingTableRecipe recipe = new CastingTableRecipe(result, fluid, type);
        this.recipes.get((Object)recipe.getTableType()).put(recipe.getInput().getFluid().getName(), recipe);
    }

    @Override
    public ICastingTableRecipe findRecipe(FluidStack fluid, ICastingTableRecipe.TableType type) {
        if (type == null || fluid == null || fluid.amount == 0) {
            return null;
        }
        ICastingTableRecipe recipe = this.recipes.get((Object)type).get(fluid.getFluid().getName());
        return recipe;
    }

    @Override
    public List<ICastingTableRecipe> getRecipes() {
        ArrayList<ICastingTableRecipe> result = new ArrayList<ICastingTableRecipe>();
        for (ICastingTableRecipe.TableType type : ICastingTableRecipe.TableType.values()) {
            result.addAll(this.recipes.get((Object)type).values());
        }
        return result;
    }

    @Override
    public void removeRecipe(ICastingTableRecipe recipe) {
        this.recipes.get((Object)recipe.getTableType()).remove(recipe.getInput().getFluid().getName());
    }
}

