/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.manager.ICastingRecipeManager;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.recipes.CastingRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CastingRecipeManager
implements ICastingRecipeManager {
    public List<ICastingRecipe> recipes = new ArrayList<ICastingRecipe>();
    public List<ItemStack> molds = new ArrayList<ItemStack>();
    public static final CastingRecipeManager instance = new CastingRecipeManager();

    private CastingRecipeManager() {
    }

    @Override
    public void addRecipe(IItemMatcher result, FluidStack in_fluid, ItemStack in_mold, IItemMatcher in_extra, int cast_speed) {
        CastingRecipe recipe = new CastingRecipe(result, in_fluid, in_mold, in_extra, cast_speed);
        if (recipe.requiresExtra()) {
            this.recipes.add(0, recipe);
        } else {
            this.recipes.add(recipe);
        }
    }

    @Override
    public void addRecipe(IItemMatcher result, FluidStack in_fluid, ItemStack in_mold, IItemMatcher in_extra) {
        this.addRecipe(result, in_fluid, in_mold, in_extra, 100);
    }

    @Override
    public ICastingRecipe findRecipe(FluidStack fluid, ItemStack mold, ItemStack extra) {
        if (mold == null || fluid == null || fluid.amount == 0) {
            return null;
        }
        for (ICastingRecipe cr : this.recipes) {
            if (!cr.matchesRecipe(mold, fluid, extra)) continue;
            return cr;
        }
        return null;
    }

    @Override
    public void addMold(ItemStack mold) {
        this.molds.add(mold.func_77946_l());
    }

    @Override
    public boolean isItemMold(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack m : this.molds) {
            if (!m.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ICastingRecipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Override
    public List<ItemStack> getMolds() {
        return Collections.unmodifiableList(this.molds);
    }

    @Override
    public void removeRecipe(ICastingRecipe recipe) {
        this.recipes.remove(recipe);
    }
}

