/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.api.recipe.IBurnerHeaterFuel;
import exter.foundry.api.recipe.manager.IBurnerHeaterFuelManager;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.recipes.BurnerHeaterFuel;
import exter.foundry.tileentity.TileEntityFoundryHeatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class BurnerHeaterFuelManager
implements IBurnerHeaterFuelManager {
    public List<IBurnerHeaterFuel> fuels = new ArrayList<IBurnerHeaterFuel>();
    public static final BurnerHeaterFuelManager instance = new BurnerHeaterFuelManager();

    private BurnerHeaterFuelManager() {
    }

    @Override
    public void addFuel(IItemMatcher fuel, int burn_time, int heat) {
        this.fuels.add(new BurnerHeaterFuel(fuel, burn_time, heat));
    }

    @Override
    public IBurnerHeaterFuel getFuel(ItemStack item) {
        for (IBurnerHeaterFuel f : this.fuels) {
            if (!f.getFuel().apply(item)) continue;
            return f;
        }
        return null;
    }

    @Override
    public List<IBurnerHeaterFuel> getFuels() {
        return Collections.unmodifiableList(this.fuels);
    }

    @Override
    public void removeFuel(IBurnerHeaterFuel fuel) {
        this.fuels.remove(fuel);
    }

    @Override
    public int getHeatNeeded(int temperature, int temp_loss_rate) {
        return TileEntityFoundryHeatable.getMaxHeatRecieve(temperature, temp_loss_rate);
    }
}

