/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.api.recipe.IAlloyMixerRecipe;
import exter.foundry.api.recipe.manager.IAlloyMixerRecipeManager;
import exter.foundry.recipes.AlloyMixerRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class AlloyMixerRecipeManager
implements IAlloyMixerRecipeManager {
    public List<IAlloyMixerRecipe> recipes = new ArrayList<IAlloyMixerRecipe>();
    public static final AlloyMixerRecipeManager instance = new AlloyMixerRecipeManager();
    private int[] recipe_order = new int[4];

    private AlloyMixerRecipeManager() {
    }

    @Override
    public void addRecipe(FluidStack out, FluidStack[] in) {
        this.recipes.add(new AlloyMixerRecipe(out, in));
    }

    @Override
    public IAlloyMixerRecipe findRecipe(FluidStack[] in, int[] order) {
        int inputs = 0;
        IAlloyMixerRecipe result = null;
        if (order != null && order.length < 4) {
            order = null;
        }
        for (IAlloyMixerRecipe r : this.recipes) {
            List<FluidStack> rinputs = r.getInputs();
            if (!r.matchesRecipe(in, this.recipe_order) || rinputs.size() <= inputs) continue;
            if (order != null) {
                System.arraycopy(this.recipe_order, 0, order, 0, this.recipe_order.length);
            }
            inputs = rinputs.size();
            result = r;
        }
        return result;
    }

    @Override
    public List<IAlloyMixerRecipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Override
    public void removeRecipe(IAlloyMixerRecipe recipe) {
        this.recipes.remove(recipe);
    }
}

